package com.icetech.base.api;

import com.icetech.base.model.IceHeartbeatOffline;
import com.icetech.base.model.IceParkDevice;
import com.icetech.base.model.IceProduceModel;
import com.icetech.base.request.ParkDeviceRequest;
import com.icetech.base.response.ParkDeviceResponse;
import com.icetech.base.response.ParkDto;
import com.icetech.common.domain.response.ObjectResponse;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * Description 设备信息查询api
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @Date 2021/5/6 10:23 上午
 */
public interface IceParkDeviceApi {

    /**
     * Description: 设备信息查询
     * Version1.0 2021-05-06 by wgy 创建
     *
     * @param serialNumber  设备号
     * @return com.icetech.aidc.model.IceDevice
     */
    ObjectResponse<IceParkDevice> getIceDevice(String serialNumber);

    /**
     * 通过sn 更新设备信息
     * @param iceParkDevice 设备信息
     * @return
     */
    ObjectResponse<Boolean> updateIceDeviceBySn(IceParkDevice iceParkDevice);

    /**
     * Description: 设备信息查询
     * Version1.0 2021-06-16 by wgy 创建
     *
     * @param serialNumber sn
     * @return com.icetech.common.domain.response.ObjectResponse<com.icetech.base.response.ParkDeviceResponse>
     */
    ObjectResponse<ParkDeviceResponse> getIceDeviceResponse(String serialNumber);

    /**
     * Description: 设备及扩展信息查询
     * Version1.0 2021-06-11 by wgy 创建
     *
     * @param serialNumbers  设备号
     * @return com.icetech.common.domain.response.ObjectResponse<com.icetech.base.response.ParkDeviceResponse>
     */
    ObjectResponse<Map<String, ParkDeviceResponse>> getIceDeviceResponseList(List<String> serialNumbers);

    /**
     * Description: 车场设备查询
     * Version1.0 2021-06-10 by wgy 创建
     *
     * @param userId            用户id
     * @param parkDeviceRequest request
     * @return com.icetech.common.domain.response.ObjectResponse<java.util.List<com.icetech.base.dto.ParkDeviceDto>>
     */
    ObjectResponse<List<ParkDeviceResponse>> getIceDeviceList(Integer userId, ParkDeviceRequest parkDeviceRequest);

    /**
     * Description: 车场查询
     * Version1.0 2021-06-11 by wgy 创建
     *
     * @param userId    当前用户id
     * @param parkName  车场名称（模糊查询）
     * @return com.icetech.common.domain.response.ObjectResponse<java.util.List<com.icetech.base.response.ParkDto>>
     */
    ObjectResponse<List<ParkDto>> getParkDto(Integer userId, String parkName);

    /**
     * Description: 查询用户下的 故障设备数
     * Version1.0 2021-06-16 by wgy 创建
     *
     * @param userId            用户id
     * @param endUpdateTime     最后离线时间
     * @return com.icetech.common.domain.response.ObjectResponse<java.lang.Integer>
     */
    ObjectResponse<Integer> getUserFaultDevice(Integer userId, Date endUpdateTime);

    /**
     * Description: 设备离线记录
     * Version1.0 2021-06-16 by wgy 创建
     *
     * @param deviceNo      设备编码
     * @param pageNo        分页参数
     * @param pageSize      分页参数
     * @return com.icetech.common.domain.response.ObjectResponse<java.util.List<com.icetech.base.model.IceDeviceOffline>>
     */
    ObjectResponse<List<IceHeartbeatOffline>> getDeviceOfflineRecord(String deviceNo, Integer pageNo, Integer pageSize);

    /**
     * Description: 获取产品型号信息
     * Version1.0 2021-06-21 by wgy 创建
     *
     * @return com.icetech.common.domain.response.ObjectResponse<java.util.List<com.icetech.base.model.IceProduceModel>>
     */
    ObjectResponse<List<IceProduceModel>> getIceProduceModel();
    /**
     * Description: 汇总设备报警数
     * Version1.0
     * @param time1 当前时间的24小时前时间点
     * @param time2 当前时间的5分钟前时间点
     * @param time3 当前时间的6分钟前时间点 定时任务1分钟1次
     * @return com.icetech.common.domain.response.ObjectResponse<java.util.List<com.icetech.base.model.IceProduceModel>>
     */
    ObjectResponse<Integer> countDeviceAlert(List<Integer> parkIdList, String time1, String time2, String time3);

    /**
     *  根据车场统计设备数
     * @param parkIdList 车场ID集合
     * @param deviceType 设备类型
     * @return
     */
    ObjectResponse<Integer> countDeviceByPark(List<Integer> parkIdList, Integer deviceType);
}
