package com.icetech.base.model;

import com.baomidou.mybatisplus.annotation.IdType;
import java.util.Date;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * 限流配置
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @date 2021-12-08
 */
@Data
@EqualsAndHashCode(callSuper = false)
@NoArgsConstructor
public class IceRouteLimit implements Serializable {

    private static final long serialVersionUID=1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 路由id
     */
    private String routeId;

    /**
     * 应用 appKey
     */
    private String appKey;

    /**
     * 限流ip，多个用英文逗号隔开
     */
    private String limitIp;

    /**
     * 服务id
     */
    private String serviceId;

    /**
     * 限流策略，1：窗口策略，2：令牌桶策略
     */
    private Integer limitType;

    /**
     * 每秒可处理请求数
     */
    private Integer execCountPerSecond;

    /**
     * 限流持续时间，默认1秒，即每durationSeconds秒允许多少请求（当limit_type=1时有效）
     */
    private Integer durationSeconds;

    /**
     * 返回的错误码
     */
    private String limitCode;

    /**
     * 返回的错误信息
     */
    private String limitMsg;

    /**
     * 令牌桶容量
     */
    private Integer tokenBucketCount;

    /**
     * 限流开启状态，1:开启，0关闭
     */
    private Integer limitStatus;

    /**
     * 顺序，值小的优先执行
     */
    private Integer orderIndex;

    /**
     * 备注
     */
    private String remark;

    @TableField(fill = FieldFill.INSERT)
    private Date createTime;

    @TableField(fill = FieldFill.UPDATE)
    private Date updateTime;


}
