package com.icetech.base.model;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.icetech.base.enums.PushEnums;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * app 消息推送信息
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @date 2021-06-23
 */
@Data
@EqualsAndHashCode(callSuper = false)
@NoArgsConstructor
public class IceAppPushMessage implements Serializable {

    private static final long serialVersionUID=1L;

    /**
     * 消息id
     */
    @TableId(value = "message_id", type = IdType.AUTO)
    private Integer messageId;

    /**
     * 模板编码，32位
     */
    private String templateCode;

    /**
     * 发送人账号
     */
    private String sendAccount;

    
    /**
     * 标题
     */
    private String title;

    /**
     * 推送内容
     */
    private String content;

    /**
     * 跳转类型（目前参见枚举）默认不跳转
     * {@link PushEnums.SkipTypeEnum}
     */
    private Integer skipType;

    /**
     * 跳转信息 根据跳转类型决定是url、对象Id等
     */
    private String skipTarget;

    /**
     * 接收人账号，多个逗号分隔 
     */
    private String receiveAccount;

    /**
     * 缩略图
     */
    private String minIcon;

    /**
     * 大图
     */
    private String maxIcon;

    /**
     * 音频富媒体元素地址。\n支持 mp3 格式音频，建议大小在5MB以内
     */
    private String audioUrl;

    /**
     * 上报或创建时间
     */
    @TableField(fill = FieldFill.INSERT)
    private Date createTime;

    /**
     * 更新时间
     */
    @TableField(fill = FieldFill.UPDATE)
    private Date updateTime;


}
