package com.icetech.base.constants;

/**
 * Description RedisConstants
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @Date 2021/5/6 10:26 上午
 */
public class RedisConstants {

    /**
     * 用户所属车场列表 过期时间
     */
    public static final long EXPIRE_BASE_USER_PARK_LIST = 30 * 60 * 1000;

    /**
     * 用户所属车场列表key
     */
    private static final String KEY_PREFIX_BASE_USER_PARK_ID_LIST = "base:user:park:id:list:";

    /**
     * 产品型号列表 过期时间
     */
    public static final long EXPIRE_BASE_PRODUCE_MODEL_LIST = 12 * 60 * 60 * 1000;

    /**
     * 产品型号列表key
     */
    private static final String KEY_PREFIX_BASE_PRODUCE_MODEL_LIST = "base:produce:model:list:";

    /**
     * 模板信息缓 过期时间
     */
    public static final long EXPIRE_BASE_PUSH_TEMPLATE_INFO = 12 * 60 * 60 * 1000;
    
    /**
     * 模板信息缓存key
     */
    private static final String KEY_PREFIX_BASE_PUSH_TEMPLATE_INFO = "base:push:template:info:";

    /**
     * 服务路由md5
     */
    private static final String KEY_SERVICE_ROUTE_MD5 = "base:service:route:md5:";

    /**
     * Description: 用户车场缓存key
     * Version1.0 2021-06-21 by wgy 创建
     * 
     * @param userId    用户id
     * @return java.lang.String       
     */
    public static String getBaseIceUserParkListKey(Integer userId) {
        return KEY_PREFIX_BASE_USER_PARK_ID_LIST + userId;
    }

    /**
     * Description: 获取产品型号列表
     * Version1.0 2021-06-21 by wgy 创建
     * 
     * @return java.lang.String       
     */
    public static String getKeyPrefixBaseProduceModelList() {
        return KEY_PREFIX_BASE_PRODUCE_MODEL_LIST;
    }

    /**
     * Description: 模板缓存信息key
     * Version1.0 2021-06-23 by wgy 创建
     * 
     * * @param templateCode    模板编码
     * @return java.lang.String       
     */
    public static String getKeyPrefixBasePushTemplateInfo(String templateCode) {
        return KEY_PREFIX_BASE_PUSH_TEMPLATE_INFO + templateCode;
    }

    /**
     * Description: 服务路由md5 key
     * Version1.0 2021-12-08 by wgy 创建
     * 
     * @param serviceId   服务id
     * @return java.lang.String       
     */
    public static String getKeyServiceRouteMd5(String serviceId) {
        return KEY_SERVICE_ROUTE_MD5 + serviceId;
    }
}
