package com.icetech.base.api;

import com.icetech.base.model.IceSaasUser;
import com.icetech.base.request.AccessTokenRequest;
import com.icetech.base.response.Ops2User;
import com.icetech.base.response.SaasUserDto;
import com.icetech.common.domain.response.ObjectResponse;

import java.util.List;

/**
 * Description SassUserApi
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @Date 2021/6/15 9:58 上午
 */
public interface SassUserApi {

    /**
     * Description: 获取当前登录的web 用户
     * Version1.0 2021-06-15 by wgy 创建
     *
     * @param accessTokenRequest   token 请求参数
     * @return com.icetech.common.domain.response.ObjectResponse<com.icetech.base.response.SaasUserDto>
     */
    ObjectResponse<SaasUserDto> getCurrentWebUser(AccessTokenRequest accessTokenRequest);

    /**
     * Description: 获取当前登录的saas 用户
     * Version1.0 2021-06-15 by wgy 创建
     *
     * @param accessTokenRequest   token 请求参数
     * @return com.icetech.common.domain.response.ObjectResponse<com.icetech.base.response.SaasUserDto>
     */
    ObjectResponse<Ops2User> getCurrentSaasUser(AccessTokenRequest accessTokenRequest);

    /**
     * Description: 获取用户的车场id 集合
     * Version1.0 2021-06-21 by wgy 创建
     *
     * @param userId    用户id
     * @return com.icetech.common.domain.response.ObjectResponse<java.util.List<java.lang.Integer>>
     */
    ObjectResponse<List<Integer>> getUserParkIdList(Integer userId);
    /**
     * Description: 获取机构下的管理员用户名列表
     * Version1.0 2021-06-28 by fangct 创建
     *
     * @param institutionId    机构id
     * @return com.icetech.common.domain.response.ObjectResponse<java.util.List<java.lang.String>>
     */
    ObjectResponse<List<IceSaasUser>> getAdminByInstitutionId(Integer institutionId);
}
