package com.icetech.base.model;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * 
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @date 2023-02-17
 */
@Data
@EqualsAndHashCode(callSuper = false)
@NoArgsConstructor
public class IceGrayConfig implements Serializable {

    private static final long serialVersionUID=1L;

    /**
     * 灰度配置id
     */
    @TableId(value = "gray_config_id", type = IdType.AUTO)
    private Long grayConfigId;

    /**
     * 灰度属性，grayOpen:是否开启灰度、grayParkCode: 配置灰度车场、graySn: 配置灰度sn、grayUser: 灰度用户、grayIp: 配置灰度ip
     */
    private String grayProperties;

    /**
     * 灰度值
     */
    private String grayValue;

    /**
     * 创建时间
     */
    @TableField(fill = FieldFill.INSERT)
    private Date createTime;

    /**
     * 更新时间
     */
    @TableField(fill = FieldFill.UPDATE)
    private Date updateTime;


}
