package com.icetech.base.model;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * 延迟消息内容
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @date 2021-10-25
 */
@Data
@EqualsAndHashCode(callSuper = false)
@NoArgsConstructor
public class IceDelayMsg implements Serializable {

    private static final long serialVersionUID=1L;

    /**
     * 消息id
     */
    @TableId(value = "delay_msg_id", type = IdType.AUTO)
    private Long delayMsgId;

    /**
     * 消息di
     */
    private String correlationId;

    /**
     * mq名字
     */
    private String mqName;

    /**
     * 交换机名称
     */
    private String exchange;

    /**
     * 路由/队列名
     */
    private String routing;

    /**
     * 延迟总时间
     */
    private Long delay;

    /**
     * 延迟剩余时间
     */
    private Long surplusDelay;

    /**
     * 消息到期时间
     */
    private Date maturityDate;

    /**
     * 消息处理标示
     */
    private Integer flag;

    /**
     * 创建时间
     */
    @TableField(fill = FieldFill.INSERT)
    private Date createTime;

    /**
     * 修改时间
     */
    private Date lastModifyDate;

    /**
     * 消息内容
     */
    private String msg;


}
