package com.icetech.base.model;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * 登录账号
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @date 2022-02-24
 */
@Data
@EqualsAndHashCode(callSuper = false)
@NoArgsConstructor
public class IceBaseAccount implements Serializable {

    private static final long serialVersionUID=1L;

    @TableId(value = "account_id", type = IdType.AUTO)
    private Long accountId;

    /**
     * 用户Id
     */
    private Long userId;

    /**
     * 标识：手机号、邮箱、 用户名、或第三方应用的唯一标识
     */
    private String account;

    /**
     * 密码凭证：站内的保存密码、站外的不保存或保存token）
     */
    private String password;

    /**
     * 昵称
     */
    private String nickName;

    /**
     * 真实姓名
     */
    private String realName;

    /**
     * 邮箱
     */
    private String email;

    /**
     * 头像
     */
    private String avatar;

    /**
     * 公司名称
     */
    private String companyName;

    /**
     * 平台类型 open:开放平台, device:设备运维平台, park: 场库服务
     */
    private String platformType;

    /**
     * username:系统用户名密码, mobile：手机号验证码, wx_mini_app：微信小程序, wx_h5: 微信h5 
     */
    private String accountType;

    /**
     * 账户域:@admin.com,@developer.com
     */
    private String domain;

    /**
     * 注册IP
     */
    private String registerIp;

    /**
     * 注册时间
     */
    @TableField(fill = FieldFill.INSERT)
    private Date createTime;

    /**
     * 状态:0-禁用 1-启用 2-锁定
     */
    private Integer status;

    /**
     * 更新时间
     */
    @TableField(fill = FieldFill.UPDATE)
    private Date updateTime;


}
