package com.icetech.base.api;

import com.icetech.common.annotation.LogIgnore;
import com.icetech.common.domain.P2cBaseMsg;
import com.icetech.common.domain.WebSocketMessage;
import com.icetech.common.domain.response.ObjectResponse;

/**
 * Description IceProxyMsgApi
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @Date 2021/6/15 9:46 上午
 */
public interface IceProxyMsgApi {

    /**
     * Description: 发送socket 消息
     * Version1.0 2021-06-15 by wgy 创建
     * 
     * @param p2cBaseMsg    p2cBaseMsg
     * @return com.icetech.common.domain.response.ObjectResponse<java.lang.Boolean>       
     */
    @LogIgnore
    ObjectResponse<Boolean> sendSocketMsg(P2cBaseMsg p2cBaseMsg);

    @LogIgnore
    ObjectResponse<Boolean> sendSocketMessage(WebSocketMessage message);
}
