package com.icetech.base.model;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * 推送模板
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @date 2021-06-23
 */
@Data
@EqualsAndHashCode(callSuper = false)
@NoArgsConstructor
public class IcePushTemplate implements Serializable {

    private static final long serialVersionUID=1L;

    /**
     * 模板id
     */
    @TableId(value = "template_id", type = IdType.AUTO)
    private Integer templateId;

    /**
     * 模板编码，32位
     */
    private String templateCode;

    /**
     * 模板表述
     */
    private String description;

    /**
     * 模板标题
     */
    private String templateTitle;

    /**
     * 模板内容 可自定义内容
     */
    private String templateContent;

    /**
     * 跳转类型（目前参见枚举）默认不跳转
     */
    private Integer skipType;

    /**
     * 上报或创建时间
     */
    @TableField(fill = FieldFill.INSERT)
    private Date createTime;

    /**
     * 更新时间
     */
    @TableField(fill = FieldFill.UPDATE)
    private Date updateTime;


}
