package com.icetech.base.api;

import com.icetech.base.model.IceGrayConfig;
import com.icetech.common.domain.response.ObjectResponse;

import java.util.List;

/**
 * Description IceGrayConfigApi
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @Date 2023/2/17 15:08
 */
public interface IceGrayConfigApi {

    /**
     * Description: 获取灰度配置
     * Version1.0 2023-02-17 by wgy 创建
     * 
     * @return com.icetech.common.domain.response.ObjectResponse<com.icetech.base.model.IceGrayConfig>       
     */
    ObjectResponse<List<IceGrayConfig>> getIceGrayConfigList();
    
    /**
     * Description: 更新配置
     * Version1.0 2023-02-17 by wgy 创建
     * 
     * @param iceGrayConfigs 配置参数
     * @return com.icetech.common.domain.response.ObjectResponse<java.lang.Boolean>       
     */
    ObjectResponse<Boolean> saveIceGrayConfig(List<IceGrayConfig> iceGrayConfigs);
}
