package com.icetech.base.response;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.Getter;

import java.io.Serializable;

/**
 * 用户返回
 * @author wangzw
 */
@Data
public class SaasUserDto implements Serializable {

    private Integer id;
    /**
     * 用户名
     */
    private String username;
    /**
     * 密码
     */
    private String password;
    /**
     * 真实姓名
     */
    private String name;
    /**
     * 联系方式
     */
    private String phone;
    /**
     * 头像
     */
    private String imgUrl;
    /**
     * 登录来源，2：云岗亭，3：中央收费站
     */
    private Integer from = 2;
    /**
     * 是否有默认通道
     */
    private Integer isDefault;
    /**
     * 用户岗位
     */
    private String userPost;
    /**
     * 角色名称
     */
    private String roleName;

    @Getter
    @AllArgsConstructor
    public enum RoleEnum{
        ROLE_NAME1("云岗亭管理员",1),
        ROLE_NAME2("车场管理员",2),
        ROLE_NAME3("系统管理员",3),
        ROLE_NAME4("智慧停车云坐席",4),
        ROLE_NAME5("云调试助手",5),
        ROLE_NAME6("中央收费员",6),
        ROLE_NAME7("超级管理员",0),
        ;
        private String roleName;
        private Integer roleType;
        public  static Integer getByRoleName(String roleName){
            for (RoleEnum roleEnum: RoleEnum.values()){
                if (roleName.equals(roleEnum.getRoleName())){
                    return roleEnum.getRoleType();
                }
            }
            return null;
        }


    }
    public  static Boolean isModify(String roleName){
        if (roleName.equals(RoleEnum.ROLE_NAME1.getRoleName())){
            return Boolean.TRUE;
        }
        if (roleName.equals(RoleEnum.ROLE_NAME2.getRoleName())){
            return Boolean.TRUE;
        }
        if (roleName.equals(RoleEnum.ROLE_NAME3.getRoleName())){
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}
