package com.icetech.base.request;

import com.icetech.common.annotation.NotNull;
import lombok.Data;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * Description PushMessageRequest
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @Date 2021/6/23 2:39 下午
 */
@Data
public class PushMessageRequest implements Serializable {

    /**
     * 模板编码，32位
     */
    @NotNull(msg = "模板编码为空")
    private String templateCode;

    /**
     * 发送人账号
     */
    @NotNull(msg = "发送账号为空")
    private String sendAccount;

    /**
     * 接收人账号
     */
    private List<String> receiveAccounts;

    /**
     * push 参数 Map
     */
    private Map<String, Object> pushParamMap;

    /**
     * 跳转信息 根据跳转类型决定是url、对象Id, 扩展参数json字符串等
     */
    private String skipTarget;

    /**
     * 缩略图
     */
    private String minIcon;

    /**
     * 大图
     */
    private String maxIcon;

    /**
     * 音频富媒体元素地址。\n支持 mp3 格式音频，建议大小在5MB以内
     */
    private String audioUrl;
}
