package com.icetech.base.request;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * Description AuditLogRequest
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @Date 2022/3/24 14:30
 */
@Data
public class LoginLogRequest implements Serializable {

    /**
     * 页码
     */
    private Integer pageNo = 1;

    /**
     * 页数
     */
    private Integer pageSize = 10;

    /**
     * 用户名
     */
    private List<String> usernames;

    /**
     * 登陆开始时间
     */
    private Date loginStartTime;

    /**
     * 登陆结束时间
     */
    private Date loginEndTime;
}
