package com.icetech.base.request;

import com.icetech.common.constants.BusinessType;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * Description AuditLogRequest
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @Date 2022/3/24 14:30
 */
@Data
public class AuditLogRequest implements Serializable {

    /**
     * 页码
     */
    private Integer pageNo = 1;

    /**
     * 页数
     */
    private Integer pageSize = 10;

    /**
     * 平台类型 open:开放平台, device:设备运维平台, park: 场库服务 
     * @see com.icetech.common.constants.PlatformType
     */
    private String platformType;

    /**
     * 操作人Id
     */
    private Long userId;

    /**
     * 操作人Id 集合
     */
    private List<Long> userIds;

    /**
     * 业务类型 
     * @see BusinessType
     */
    private Integer businessType;

    /**
     * 操作开始时间
     */
    private Date operationStartTime;

    /**
     * 操作结束时间
     */
    private Date operationEndTime;
}
