package com.icetech.base.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * 用户表
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @date 2021-06-07
 */
@Data
@EqualsAndHashCode(callSuper = false)
@NoArgsConstructor
public class IceSaasUser implements Serializable {

    private static final long serialVersionUID=1L;

    /**
     * iD (主健自增)
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    /**
     * 用户名
     */
    private String username;

    /**
     * 密码
     */
    private String password;

    /**
     * 真实姓名
     */
    private String name;

    /**
     * 联系方式
     */
    private String phone;

    /**
     * 状态（0正常、1冻结
     */
    private Integer status;

    /**
     * 系统自动添加 0人工录入，1系统自动生成
     */
    private Integer sysAdd;

    /**
     * 所属机构
     */
    private Integer institutionId;

    /**
     * 角色ID
     */
    private Integer roleId;

    /**
     * 是否删除（0正常、1删除）
     */
    private Integer isDelete;

    /**
     * 添加人
     */
    private String adder;

    /**
     * 添加时间
     */
    private Date addTime;

    /**
     * 最后登录时间
     */
    private Date lastLogin;

    /**
     * 最后登录ip
     */
    private String lastIp;

    /**
     * 用户岗位
     */
    private String userPost;


}
