package com.icetech.base.model;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * 产品型号信息
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @date 2021-06-21
 */
@Data
@EqualsAndHashCode(callSuper = false)
@NoArgsConstructor
public class IceProduceModel implements Serializable {

    private static final long serialVersionUID=1L;

    /**
     * id
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    /**
     * 产品型号
     */
    private String productModel;

    /**
     * 对外产品型号
     */
    private String productModelExternal;

    /**
     * 产品说明
     */
    private String productIntroduction;

    /**
     * 支持IOT 对应的版本, -1 为不支持
     */
    private Integer iot;

    /**
     * 支持WS 对应版本
     */
    private Integer ws;

    /**
     * 协议自动切换 对应版本
     */
    private Integer autoProtocol;

    /**
     * ws 协议切换 对应版本号
     */
    private Integer wsProtocol;

    /**
     * 日志上传下载功能 对应版本
     */
    private Integer logFunction;

    /**
     * p2p开闸 对应版本
     */
    private Integer p2pOpening;

    /**
     * ws开闸 对应版本
     */
    private Integer wsOpening;

    /**
     * p2p重启 对应版本
     */
    private Integer p2pRestart;

    /**
     * ws重启 对应版本
     */
    private Integer wsRestart;

    /**
     * 云端升级 对应版本
     */
    private Integer cloudUpgrade;

    /**
     * p2p调试 对应版本
     */
    private Integer p2pDebug;

    /**
     * h5调试 对应版本
     */
    private Integer h5Debug;

    /**
     * ws调试 对应版本
     */
    private Integer wsDebug;

    /**
     * 云平台批量下发 对应版本
     */
    private Integer cloudBatchIssue;

    /**
     * 电动云台 对应版本
     */
    private Integer electricPanTilt;

    /**
     * 端网长开闸 对应版本
     */
    private Integer longOpening;

    /**
     * 脱机计费 对应版本
     */
    private Integer offlineBilling;

    /**
     * 4G 对应版本
     */
    private Integer is4g;

    /**
     * 遥控功能 对应版本
     */
    private Integer remoteControl;

    /**
     * LED控制卡
     */
    private String ledControlCard;

    /**
     * 在线申请三元组 对应版本
     */
    private Integer applyTriplet;

    /**
     * 上报型号和版本号 对应版本
     */
    private Integer reportModel;

    /**
     * 业务优化 对应版本
     */
    private Integer businessOptimization;

    /**
     * 上报或创建时间
     */
    @TableField(fill = FieldFill.INSERT)
    private Date createTime;

    /**
     * 更新时间
     */
    @TableField(fill = FieldFill.UPDATE)
    private Date updateTime;


}
