package com.icetech.base.model;

import com.baomidou.mybatisplus.annotation.IdType;
import java.util.Date;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * 接口监控信息
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @date 2021-12-08
 */
@Data
@EqualsAndHashCode(callSuper = false)
@NoArgsConstructor
public class IceMonitorInfo implements Serializable {

    private static final long serialVersionUID=1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 路由id
     */
    private String routeId;

    /**
     * 接口名
     */
    private String name;

    /**
     * 版本号
     */
    private String version;

    private String serviceId;

    private String instanceId;

    /**
     * 请求耗时最长时间
     */
    private Integer maxTime;

    /**
     * 请求耗时最小时间
     */
    private Integer minTime;

    /**
     * 总时长，毫秒
     */
    private Long totalTime;

    /**
     * 总调用次数
     */
    private Long totalRequestCount;

    /**
     * 成功次数
     */
    private Long successCount;

    /**
     * 失败次数（业务主动抛出的异常算作成功，如参数校验，未知的错误算失败）
     */
    private Long errorCount;

    @TableField(fill = FieldFill.INSERT)
    private Date createTime;

    @TableField(fill = FieldFill.UPDATE)
    private Date updateTime;


}
