package com.icetech.base.domain;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @author wanggang
 * @create 2022-03-01 15:11
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class CreateUserDTO implements Serializable {
    /**
     *  用户名
     */
    private String username;
    /**
     * 密码
     */
    private String password;
    /**
     * 平台类型 open:开放平台, device:设备运维平台, park: 场库服务
     */
    private String platformType;
    /**
     * 'username:系统用户名密码, mobile:手机号验证码, wx_mini_app:微信小程序, wx_h5: 微信h5'
     */
    private String accountType;
    /**
     * 真实姓名
     */
    private String realName;
    /**
     * 公司名称
     */
    private String companyName;
    /**
     * 手机号
     */
    private String mobile;
}
