package com.icetech.base.constants;

import java.io.Serializable;

/**
 * 小程序认证常量
 * @author wangzw
 */
public interface SecurityConstant extends Serializable {
    /**
     * token参数头
     */
    String HEADER = "accessToken";
    /**
     * 交互小程序商户 token 前缀key
     */
    String TOKEN_PRE_MAPP = "MAPP_TOKEN_PRE:";

    /**
     * 用户小程序商户 token 前缀key 单点登录使用
     */
    String USER_TOKEN_MAPP = "MAPP_USER_TOKEN:";

    /**
     * 交互小程序管家 token 前缀key
     */
    String TOKEN_PRE_CAPP = "CAPP_TOKEN_PRE:";
    /**
     * 远程升级 token 前缀
     */
    String TOKEN_PRE_OPS = "user:info:";

    /**
     * 用户小程序管家 token 前缀key 单点登录使用
     */
    String USER_TOKEN_CAPP = "CAPP_USER_TOKEN:";

    /**
     * 优惠券前缀编码
     */
    String DISCOUNT_NO = "DISCOUNT_NO:";

    /**
     * 交互公众号 token 前缀key
     */
    String TOKEN_PRE_MP = "MP_TOKEN_PRE:";

    /**
     * 用户公众号 token 前缀key 单点登录使用
     */
    String USER_TOKEN_MP = "MP_USER_TOKEN:";

    /**
     * 短信验证码前缀
     */
    String MSG_PRE_MP = "MSG_PRE_MP:";
    /**
     * 车主端统计
     */
    String PARK_PRE_BOSS = "PARK_PRE_BOSS:";
}
