package com.icetech.base.api;

import com.icetech.base.domain.CreateUserDTO;
import com.icetech.base.domain.ForgetPwdDTO;
import com.icetech.base.model.IceBaseAccount;
import com.icetech.base.response.CreateUserResponse;
import com.icetech.common.domain.response.ObjectResponse;

/**
 * @author wanggang
 * @create 2022-02-25 17:25
 */
public interface IceBaseAccountApi {

    /**
     * 登录用户用户信息
     *
     * @param account      用户标识
     * @param platformType 平台类型
     * @param accountType  账户类型
     * @return
     */
    ObjectResponse<IceBaseAccount> getBaseAccountBy(String account, String platformType, String accountType);

    /**
     * 创建登录账户信息
     *
     * @param dto
     * @return
     */
    ObjectResponse<Long> createAccount(CreateUserDTO dto);
    
    /**
     * Description: 创建账号和用户
     * Version1.0 2022-06-24 by wgy 创建
     * 
     * @param dto   参数
     * @return com.icetech.common.domain.response.ObjectResponse<CreateUserResponse>       
     */
    ObjectResponse<CreateUserResponse> createAccountUser(CreateUserDTO dto);


    /**
     * 修改密码
     *
     * @param accountId
     * @param oldPassword
     * @param newPassword
     * @return
     */
    ObjectResponse<Boolean> updatePassword(Long accountId, String oldPassword, String newPassword);


    /**
     * 忘记密码
     *
     * @param dto
     * @return
     */
    ObjectResponse<Boolean> forgetPassword(ForgetPwdDTO dto);
}
