package com.icetech.base.api;

import com.icetech.base.model.IceAppInfo;
import com.icetech.common.domain.response.ObjectResponse;

import java.util.List;

/**
 * Description IceAppInfoApi
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @Date 2021/12/14 1:38 下午
 */
public interface IceAppInfoApi {

    /**
     * Description: 获取app 应用信息
     * Version1.0 2021-12-10 by wgy 创建
     *
     * @return com.icetech.common.domain.response.ObjectResponse<java.util.List<com.icetech.base.model.IceIpBlack>>       
     */
    ObjectResponse<List<IceAppInfo>> getIceAppInfoList();

    /**
     * 增加 应用信息
     * @param iceAppInfo    应用信息
     * @return  Boolean
     */
    ObjectResponse<Boolean> addIceAppInfo(IceAppInfo iceAppInfo);

    /**
     * Description: 获取app 应用信息
     * Version1.0 2021-12-10 by wgy 创建
     * @param userId    用户id
     *
     * @return com.icetech.common.domain.response.ObjectResponse<java.util.List<com.icetech.base.model.IceIpBlack>>
     */
    ObjectResponse<List<IceAppInfo>> getIceAppInfoListByUser(Integer userId);

    /**
     * Description: appId 查询应用信息
     * Version1.0 2022-11-01 by wgy 创建
     *
     * @param appId appId
     * @return com.icetech.base.model.IceAppInfo
     */
    ObjectResponse<IceAppInfo> getIceAppInfoByAppId(String appId);
}
