package com.icetech.p2p.model;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * 设备日志下载列表
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @date 2021-06-11
 */
@Data
@EqualsAndHashCode(callSuper = false)
@NoArgsConstructor
public class IceDeviceFile implements Serializable {

    private static final long serialVersionUID=1L;

    /**
     * id
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    /**
     * 相机序列号
     */
    private String serialNumber;

    /**
     * 日志文件路径
     */
    private String fileName;

    /**
     * 文件地址
     */
    private String filePath;

    /**
     * 文件类型，1：日志文件
     */
    private Integer fileType;

    /**
     * 上报或创建时间
     */
    @TableField(fill = FieldFill.INSERT)
    private Date createTime;

    /**
     * 更新时间
     */
    @TableField(fill = FieldFill.UPDATE)
    private Date updateTime;

    public enum FileTypeEnum {
        //日志文件类型
        log(1);
        public int val;
        FileTypeEnum(int val){
            this.val = val;
        }
    }
}
