/*
 * Decompiled with CFR 0.152.
 */
package com.netsdk.lib;

import com.netsdk.lib.NetSDKLib;
import com.sun.jna.IntegerType;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import com.sun.jna.Structure;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class Utils {
    private static boolean checking = false;

    public static String getPlatformEncode() {
        String encode = "";
        String osPrefix = Utils.getOsPrefix();
        if (osPrefix.toLowerCase().startsWith("win32")) {
            encode = "GBK";
        } else if (osPrefix.toLowerCase().startsWith("linux")) {
            encode = "UTF-8";
        } else if (osPrefix.toLowerCase().startsWith("mac")) {
            encode = "UTF-8";
        }
        if (encode.isEmpty()) {
            encode = "UTF-8";
        }
        return encode;
    }

    public static String getOsPrefix() {
        String osPrefix;
        String arch = System.getProperty("os.arch").toLowerCase();
        String name = System.getProperty("os.name");
        switch (Platform.getOSType()) {
            case 2: {
                if ("i386".equals(arch)) {
                    arch = "x86";
                }
                osPrefix = "win32-" + arch;
                break;
            }
            case 1: {
                if ("x86".equals(arch)) {
                    arch = "i386";
                } else if ("x86_64".equals(arch)) {
                    arch = "amd64";
                }
                osPrefix = "linux-" + arch;
                break;
            }
            case 0: {
                arch = System.getProperty("sun.arch.data.model");
                osPrefix = "mac-" + arch;
                break;
            }
            default: {
                int space;
                osPrefix = name.toLowerCase();
                if ("x86".equals(arch)) {
                    arch = "i386";
                }
                if ("x86_64".equals(arch)) {
                    arch = "amd64";
                }
                if ((space = osPrefix.indexOf(" ")) != -1) {
                    osPrefix = osPrefix.substring(0, space);
                }
                osPrefix = osPrefix + "-" + arch;
            }
        }
        return osPrefix;
    }

    public static String getOsName() {
        String osName = "";
        String osPrefix = Utils.getOsPrefix();
        if (osPrefix.toLowerCase().startsWith("win32-x86") || osPrefix.toLowerCase().startsWith("win32-amd64")) {
            osName = "win";
        } else if (osPrefix.toLowerCase().startsWith("linux-i386") || osPrefix.toLowerCase().startsWith("linux-amd64")) {
            osName = "linux";
        } else if (osPrefix.toLowerCase().startsWith("mac-64") || osPrefix.toLowerCase().startsWith("mac-32")) {
            osName = "mac";
        }
        return osName;
    }

    public static String getLoadLibrary(String library) {
        if (Utils.isChecking()) {
            return null;
        }
        String loadLibrary = "";
        String osPrefix = Utils.getOsPrefix();
        if (osPrefix.toLowerCase().startsWith("win32-x86")) {
            loadLibrary = "./libs/win32/";
        } else if (osPrefix.toLowerCase().startsWith("win32-amd64")) {
            loadLibrary = "./libs/win64/";
        } else if (osPrefix.toLowerCase().startsWith("linux-i386")) {
            loadLibrary = "";
        } else if (osPrefix.toLowerCase().startsWith("linux-amd64")) {
            loadLibrary = "";
        } else if (osPrefix.toLowerCase().startsWith("mac-64")) {
            loadLibrary = "";
        }
        System.out.printf("\u52a0\u8f7d\u5e93[%s]\n", loadLibrary + library);
        return loadLibrary + library;
    }

    public static void setChecking() {
        checking = true;
    }

    public static void clearChecking() {
        checking = false;
    }

    public static boolean isChecking() {
        return checking;
    }

    public static String getDate() {
        SimpleDateFormat simpleDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return simpleDate.format(new Date()).replace(" ", "_").replace(":", "-");
    }

    public static class SdkStructure
    extends Structure {
        @Override
        protected List<String> getFieldOrder() {
            ArrayList<String> fieldOrderList = new ArrayList<String>();
            Class<?> cls = this.getClass();
            while (!cls.equals(NetSDKLib.SdkStructure.class)) {
                Field[] fields;
                for (Field field : fields = cls.getDeclaredFields()) {
                    int modifiers = field.getModifiers();
                    if (Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers)) continue;
                    fieldOrderList.add(field.getName());
                }
                cls = cls.getSuperclass();
            }
            return fieldOrderList;
        }
    }

    public static class LLong
    extends IntegerType {
        private static final long serialVersionUID = 1L;
        public static int size = Native.LONG_SIZE;

        public LLong() {
            this(0L);
        }

        public LLong(long value) {
            super(size, value);
        }

        static {
            if (Utils.getOsPrefix().toLowerCase().equals("linux-amd64") || Utils.getOsPrefix().toLowerCase().equals("win32-amd64") || Utils.getOsPrefix().toLowerCase().equals("mac-64")) {
                size = 8;
            } else if (Utils.getOsPrefix().toLowerCase().equals("linux-i386") || Utils.getOsPrefix().toLowerCase().equals("win32-x86")) {
                size = 4;
            }
        }
    }
}

