/*
 * Decompiled with CFR 0.152.
 */
package com.netsdk.demo.module;

import com.netsdk.demo.module.LoginModule;
import com.netsdk.lib.ImageAlgLib;
import com.netsdk.lib.NetSDKLib;
import com.netsdk.lib.ToolKits;
import com.netsdk.lib.structure.NET_IN_RADIOMETRY_RANDOM_REGION_TEMPER;
import com.netsdk.lib.structure.NET_OUT_RADIOMETRY_RANDOM_REGION_TEMPER;
import java.io.IOException;

public class ThermalCameraModule {
    static ImageAlgLib imageAlgApi = ImageAlgLib.IMAGEALG_INSTANCE;
    private static ThermalCameraStatus status = new ThermalCameraStatus();

    public static boolean radiometryAttach(int nChannel, NetSDKLib.fRadiometryAttachCB cbNotify) {
        NetSDKLib.NET_IN_RADIOMETRY_ATTACH stIn = new NetSDKLib.NET_IN_RADIOMETRY_ATTACH();
        stIn.nChannel = nChannel;
        stIn.cbNotify = cbNotify;
        NetSDKLib.NET_OUT_RADIOMETRY_ATTACH stOut = new NetSDKLib.NET_OUT_RADIOMETRY_ATTACH();
        ThermalCameraModule.status.hRadiometryHandle = LoginModule.netsdk.CLIENT_RadiometryAttach(LoginModule.m_hLoginHandle, stIn, stOut, 3000);
        if (ThermalCameraModule.status.hRadiometryHandle.longValue() == 0L) {
            System.err.printf("RadiometryAttach Failed!" + ToolKits.getErrorCodePrint(), new Object[0]);
        }
        return ThermalCameraModule.status.hRadiometryHandle.longValue() != 0L;
    }

    public static boolean isAttaching() {
        return ThermalCameraModule.status.hRadiometryHandle.longValue() != 0L;
    }

    public static int radiometryFetch(int nChannel) {
        int nStatus = -1;
        NetSDKLib.NET_IN_RADIOMETRY_FETCH stIn = new NetSDKLib.NET_IN_RADIOMETRY_FETCH();
        stIn.nChannel = nChannel;
        NetSDKLib.NET_OUT_RADIOMETRY_FETCH stOut = new NetSDKLib.NET_OUT_RADIOMETRY_FETCH();
        if (!LoginModule.netsdk.CLIENT_RadiometryFetch(LoginModule.m_hLoginHandle, stIn, stOut, 3000)) {
            System.err.printf("RadiometryFetch Failed!" + ToolKits.getErrorCodePrint(), new Object[0]);
        } else {
            nStatus = stOut.nStatus;
        }
        return nStatus;
    }

    public static boolean saveData(NetSDKLib.NET_RADIOMETRY_DATA radiometryData) throws IOException {
        if (radiometryData == null) {
            return false;
        }
        int nWidth = radiometryData.stMetaData.nWidth;
        int nHeight = radiometryData.stMetaData.nHeight;
        short[] pGrayImg = new short[nWidth * nHeight];
        float[] pTempForPixels = new float[nWidth * nHeight];
        if (!LoginModule.netsdk.CLIENT_RadiometryDataParse(radiometryData, pGrayImg, pTempForPixels)) {
            System.err.println("saveData failed!" + ToolKits.getErrorCodePrint());
            return false;
        }
        byte[] pYData = new byte[nWidth * nHeight * 2];
        imageAlgApi.drcTable(pGrayImg, (short)nWidth, (short)nHeight, 0, pYData, null);
        ToolKits.savePicture(pYData, "./GrayscaleMap.yuv");
        return true;
    }

    public static void radiometryDetach() {
        if (ThermalCameraModule.status.hRadiometryHandle.longValue() != 0L) {
            LoginModule.netsdk.CLIENT_RadiometryDetach(ThermalCameraModule.status.hRadiometryHandle);
            ThermalCameraModule.status.hRadiometryHandle.setValue(0L);
        }
    }

    public static NetSDKLib.NET_RADIOMETRYINFO queryPointTemper(int nChannel, short x, short y) {
        int nQueryType = 12;
        NetSDKLib.NET_IN_RADIOMETRY_GETPOINTTEMPER stIn = new NetSDKLib.NET_IN_RADIOMETRY_GETPOINTTEMPER();
        stIn.nChannel = nChannel;
        stIn.stCoordinate.nx = x;
        stIn.stCoordinate.ny = y;
        NetSDKLib.NET_OUT_RADIOMETRY_GETPOINTTEMPER stOut = new NetSDKLib.NET_OUT_RADIOMETRY_GETPOINTTEMPER();
        stIn.write();
        stOut.write();
        boolean bRet = LoginModule.netsdk.CLIENT_QueryDevInfo(LoginModule.m_hLoginHandle, nQueryType, stIn.getPointer(), stOut.getPointer(), null, 3000);
        if (!bRet) {
            System.err.printf("QueryPointTemper Failed!" + ToolKits.getErrorCodePrint(), new Object[0]);
            return null;
        }
        stOut.read();
        return stOut.stPointTempInfo;
    }

    public static NET_OUT_RADIOMETRY_RANDOM_REGION_TEMPER radiometryGetRandomRegionTemper(int channel, int pointNum, short[][] nPoints) {
        NET_IN_RADIOMETRY_RANDOM_REGION_TEMPER stIn = new NET_IN_RADIOMETRY_RANDOM_REGION_TEMPER();
        NET_OUT_RADIOMETRY_RANDOM_REGION_TEMPER stOut = new NET_OUT_RADIOMETRY_RANDOM_REGION_TEMPER();
        stIn.nChannel = channel;
        stIn.nPointNum = pointNum;
        for (int i = 0; i < pointNum; ++i) {
            stIn.stuPolygon[i].nx = nPoints[i][0];
            stIn.stuPolygon[i].ny = nPoints[i][1];
        }
        stIn.write();
        stOut.write();
        boolean bet = LoginModule.netsdk.CLIENT_RadiometryGetRandomRegionTemper(LoginModule.m_hLoginHandle, stIn.getPointer(), stOut.getPointer(), 3000);
        stIn.read();
        stOut.read();
        if (!bet) {
            System.err.println("\u83b7\u53d6\u6d4b\u6e29\u533a\u57df\u7684\u53c2\u6570\u503c\u5931\u8d25," + ToolKits.getErrorCodePrint());
        }
        return stOut;
    }

    public static NetSDKLib.NET_RADIOMETRYINFO queryItemTemper(int nChannel, int nPresetId, int nRuleId, int nMeterType) {
        int nQueryType = 13;
        NetSDKLib.NET_IN_RADIOMETRY_GETTEMPER stIn = new NetSDKLib.NET_IN_RADIOMETRY_GETTEMPER();
        stIn.stCondition.nPresetId = nPresetId;
        stIn.stCondition.nRuleId = nRuleId;
        stIn.stCondition.nMeterType = nMeterType;
        stIn.stCondition.nChannel = nChannel;
        NetSDKLib.NET_OUT_RADIOMETRY_GETTEMPER stOut = new NetSDKLib.NET_OUT_RADIOMETRY_GETTEMPER();
        stIn.write();
        stOut.write();
        boolean bRet = LoginModule.netsdk.CLIENT_QueryDevInfo(LoginModule.m_hLoginHandle, nQueryType, stIn.getPointer(), stOut.getPointer(), null, 3000);
        if (!bRet) {
            System.err.printf("QueryPointTemper Failed!" + ToolKits.getErrorCodePrint(), new Object[0]);
            return null;
        }
        stOut.read();
        return stOut.stTempInfo;
    }

    public static boolean startFind(NetSDKLib.NET_IN_RADIOMETRY_STARTFIND stuIn) {
        if (ThermalCameraModule.status.bSearching) {
            ThermalCameraModule.stopFind();
        }
        NetSDKLib.NET_OUT_RADIOMETRY_STARTFIND stuOut = new NetSDKLib.NET_OUT_RADIOMETRY_STARTFIND();
        stuIn.write();
        stuOut.write();
        ThermalCameraModule.status.bSearching = LoginModule.netsdk.CLIENT_StartFind(LoginModule.m_hLoginHandle, 0, stuIn.getPointer(), stuOut.getPointer(), 5000);
        if (ThermalCameraModule.status.bSearching) {
            stuOut.read();
            ThermalCameraModule.status.nFinderHanle = stuOut.nFinderHanle;
            ThermalCameraModule.status.nTotalCount = stuOut.nTotalCount;
        } else {
            System.err.printf("startFind Failed!" + ToolKits.getErrorCodePrint(), new Object[0]);
        }
        return ThermalCameraModule.status.bSearching;
    }

    public static int getTotalCount() {
        return ThermalCameraModule.status.nTotalCount;
    }

    public static NetSDKLib.NET_OUT_RADIOMETRY_DOFIND doFind(int nOffset, int nCount) {
        if (!ThermalCameraModule.status.bSearching) {
            System.err.printf("DoFind Failed! [need startFind]", new Object[0]);
            return null;
        }
        NetSDKLib.NET_IN_RADIOMETRY_DOFIND stuIn = new NetSDKLib.NET_IN_RADIOMETRY_DOFIND();
        stuIn.nFinderHanle = ThermalCameraModule.status.nFinderHanle;
        stuIn.nBeginNumber = nOffset;
        stuIn.nCount = nCount;
        NetSDKLib.NET_OUT_RADIOMETRY_DOFIND stuOut = new NetSDKLib.NET_OUT_RADIOMETRY_DOFIND();
        stuIn.write();
        stuOut.write();
        if (!LoginModule.netsdk.CLIENT_DoFind(LoginModule.m_hLoginHandle, 0, stuIn.getPointer(), stuOut.getPointer(), 5000)) {
            System.err.printf("DoFind Failed!" + ToolKits.getErrorCodePrint(), new Object[0]);
            return null;
        }
        stuOut.read();
        return stuOut;
    }

    public static void stopFind() {
        if (!ThermalCameraModule.status.bSearching) {
            return;
        }
        NetSDKLib.NET_IN_RADIOMETRY_STOPFIND stuIn = new NetSDKLib.NET_IN_RADIOMETRY_STOPFIND();
        stuIn.nFinderHanle = ThermalCameraModule.status.nFinderHanle;
        NetSDKLib.NET_OUT_RADIOMETRY_STOPFIND stuOut = new NetSDKLib.NET_OUT_RADIOMETRY_STOPFIND();
        stuIn.write();
        stuOut.write();
        LoginModule.netsdk.CLIENT_StopFind(LoginModule.m_hLoginHandle, 0, stuIn.getPointer(), stuOut.getPointer(), 5000);
        ThermalCameraModule.status.bSearching = false;
        ThermalCameraModule.status.nFinderHanle = 0;
    }

    public static class ThermalCameraStatus {
        public boolean bSearching = false;
        public int nFinderHanle;
        public int nTotalCount;
        public NetSDKLib.LLong hRadiometryHandle = new NetSDKLib.LLong(0L);
    }
}

