/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.quick;

import cn.dev33.satoken.context.SaHolder;
import cn.dev33.satoken.filter.SaServletFilter;
import cn.dev33.satoken.quick.SaQuickManager;
import cn.dev33.satoken.quick.config.SaQuickConfig;
import cn.dev33.satoken.quick.web.SaQuickController;
import cn.dev33.satoken.router.SaRouter;
import cn.dev33.satoken.stp.StpUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.annotation.Order;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@Import(value={SaQuickController.class})
public class SaQuickBean
implements WebMvcConfigurer {
    @Bean
    @ConfigurationProperties(prefix="sa")
    public SaQuickConfig getSaQuickConfig() {
        return new SaQuickConfig();
    }

    @Autowired
    public void setSaQuickConfig(SaQuickConfig saQuickConfig) {
        SaQuickManager.setConfig(saQuickConfig);
    }

    @Bean
    @Order(value=-101)
    public SaServletFilter getSaServletFilter() {
        return new SaServletFilter().addInclude(SaQuickManager.getConfig().getInclude().split(",")).addExclude(SaQuickManager.getConfig().getExclude().split(",")).addExclude(new String[]{"/favicon.ico", "/saLogin", "/doLogin", "/sa-res/**"}).setAuth(r -> {
            if (SaQuickManager.getConfig().getAuth().booleanValue() && !StpUtil.isLogin()) {
                SaHolder.getRequest().forward("/saLogin");
                SaRouter.back();
            }
        }).setError(e -> e.getMessage());
    }
}

