/*
 * Decompiled with CFR 0.152.
 */
package com.qingstor.sdk.upload;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.qingstor.sdk.annotation.ParamAnnotation;
import com.qingstor.sdk.exception.QSException;
import com.qingstor.sdk.model.OutputModel;
import com.qingstor.sdk.model.UploadModel;
import com.qingstor.sdk.request.CancellationHandler;
import com.qingstor.sdk.request.RequestHandler;
import com.qingstor.sdk.service.Bucket;
import com.qingstor.sdk.upload.Recorder;
import com.qingstor.sdk.upload.UploadManagerCallback;
import com.qingstor.sdk.upload.UploadProgressListener;
import com.qingstor.sdk.utils.QSStringUtil;
import com.qingstor.sdk.utils.UrlUtils;
import java.io.File;
import java.io.IOException;

public class UploadManager {
    private static final ObjectMapper om = new ObjectMapper();
    private long partSize = 0x400000L;
    private static final int MAX_PART_COUNTS = 10000;
    private int partCounts;
    private Recorder recorder;
    private Bucket bucket;
    private UploadProgressListener progressListener;
    private CancellationHandler cancellationHandler;
    private UploadModel uploadModel;
    private UploadManagerCallback callBack;

    public UploadManager(Bucket bucket, Recorder recorder, UploadProgressListener progressListener, CancellationHandler cancellationHandler, UploadManagerCallback callBack) {
        this.recorder = recorder;
        this.bucket = bucket;
        this.progressListener = progressListener;
        this.cancellationHandler = cancellationHandler;
        this.callBack = callBack;
    }

    public UploadManager(Bucket bucket, UploadManagerCallback callBack) {
        this(bucket, null, null, null, callBack);
    }

    public void put(File file) throws QSException {
        if (!file.exists() || file.isDirectory()) {
            throw new QSException("File does not exist or it is a directory.");
        }
        this.put(file, file.getName(), null, "");
    }

    public void put(File file, String objectKey, String fileName, String eTag) throws QSException {
        if (!file.exists() || file.isDirectory()) {
            throw new QSException("File does not exist or it is a directory.");
        }
        long length = file.length();
        if (length < 1L) {
            throw new QSException("The size of file cannot be smaller than 1 byte.");
        }
        if (length <= this.partSize) {
            this.partCounts = 1;
            this.putFile(file, objectKey, fileName, length);
        } else {
            if (length / this.partSize > 10000L) {
                this.partSize = length / 10000L;
                this.partCounts = 10000;
                if (this.partSize > 0x140000000L) {
                    throw new QSException("The size of file is too large.");
                }
            } else {
                this.partCounts = (int)(length / this.partSize);
                if (length % this.partSize > 0L) {
                    ++this.partCounts;
                }
            }
            this.putFileMulti(file, objectKey, fileName, eTag, length);
        }
    }

    public void putFileMulti(File file, String objectKey, String fileName, String eTag, long length) throws QSException {
        if (this.partSize < 0x400000L) {
            throw new QSException("Every part of the file can not smaller than 4 MB.");
        }
        if (this.recorder == null || this.recorder.get(objectKey) == null) {
            Bucket.InitiateMultipartUploadInput inputInit = new Bucket.InitiateMultipartUploadInput();
            Bucket.InitiateMultipartUploadOutput initOutput = this.bucket.initiateMultipartUpload(objectKey, inputInit);
            int code = initOutput.getStatueCode();
            if (code < 200 || code >= 300) {
                if (this.callBack != null) {
                    OutputModel outputModel = new OutputModel();
                    outputModel.setStatueCode(code);
                    outputModel.setMessage(initOutput.getMessage());
                    this.callBack.onAPIResponse(objectKey, outputModel);
                }
                return;
            }
            this.uploadModel = new UploadModel();
            this.uploadModel.setTotalSize(length);
            this.uploadModel.setUploadID(initOutput.getUploadID());
        } else {
            byte[] bytes = this.recorder.get(objectKey);
            String json = new String(bytes);
            try {
                this.uploadModel = (UploadModel)om.readValue(json, UploadModel.class);
            }
            catch (IOException e) {
                throw new QSException(e.getMessage(), e);
            }
            if (this.uploadModel.isUploadComplete()) {
                if (this.callBack != null) {
                    OutputModel outputModel = new OutputModel();
                    outputModel.setStatueCode(201);
                    outputModel.setMessage("This task has been uploaded.");
                    this.callBack.onAPIResponse(objectKey, outputModel);
                }
                return;
            }
        }
        this.uploadModel.setTotalSize(length);
        if (this.uploadModel.isFileComplete()) {
            this.completeMultiUpload(objectKey, fileName, eTag, this.uploadModel.getUploadID(), length);
        } else {
            for (int i = this.uploadModel.getCurrentPart(); i < this.partCounts; ++i) {
                this.uploadModel.setCurrentPart(i);
                this.uploadModel.setBytesWritten((long)i * this.partSize);
                this.setData(objectKey, this.recorder);
                if (this.cancellationHandler != null && this.cancellationHandler.isCancelled()) {
                    this.setData(objectKey, this.recorder);
                    break;
                }
                long contentLength = Math.min(this.partSize, file.length() - (long)this.uploadModel.getCurrentPart() * this.partSize);
                Bucket.UploadMultipartInput input = new Bucket.UploadMultipartInput();
                input.setBodyInputFilePart(file);
                input.setFileOffset((long)i * this.partSize);
                input.setContentLength(contentLength);
                input.setPartNumber(i);
                input.setUploadID(this.uploadModel.getUploadID());
                RequestHandler requestHandler = this.bucket.uploadMultipartRequest(objectKey, input);
                if (this.progressListener != null) {
                    requestHandler.setProgressListener((long len, long size) -> {
                        long bytesWritten = (long)this.uploadModel.getCurrentPart() * this.partSize + len;
                        this.progressListener.onProgress(objectKey, bytesWritten, length);
                    });
                }
                requestHandler.setCancellationHandler(this.cancellationHandler);
                this.sign(requestHandler);
                OutputModel send = requestHandler.send();
                if (send.getStatueCode() != 200 && send.getStatueCode() != 201) {
                    this.setData(objectKey, this.recorder);
                    if (this.callBack == null) break;
                    this.callBack.onAPIResponse(objectKey, send);
                    break;
                }
                if (i != this.partCounts - 1) continue;
                this.uploadModel.setBytesWritten(length);
                this.uploadModel.setFileComplete(true);
                this.setData(objectKey, this.recorder);
            }
            if (this.uploadModel.isFileComplete()) {
                this.completeMultiUpload(objectKey, fileName, eTag, this.uploadModel.getUploadID(), length);
            }
        }
    }

    private void sign(RequestHandler requestHandler) throws QSException {
        if (this.callBack != null) {
            String correctTime;
            String signed = this.callBack.onSignature(requestHandler.getStringToSignature());
            if (!QSStringUtil.isEmpty(signed)) {
                requestHandler.setSignature(this.callBack.onAccessKey(), signed);
            }
            if ((correctTime = this.callBack.onCorrectTime(requestHandler.getStringToSignature())) != null && correctTime.trim().length() > 0) {
                requestHandler.getBuilder().setHeader("Date", correctTime);
            }
        }
    }

    private void setData(String objectKey, Recorder recorder) {
        if (recorder == null) {
            return;
        }
        String upload = null;
        try {
            upload = om.writeValueAsString((Object)this.uploadModel);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        recorder.set(objectKey, upload.getBytes());
    }

    private void completeMultiUpload(String objectKey, String fileName, String eTag, String uploadID, long length) throws QSException {
        CompleteMultipartUploadInput completeMultipartUploadInput = new CompleteMultipartUploadInput(uploadID, this.partCounts, 0);
        completeMultipartUploadInput.setContentLength(length);
        if (!QSStringUtil.isEmpty(fileName)) {
            String keyName = UrlUtils.rfc3986UriEncode(fileName, true);
            completeMultipartUploadInput.setContentDisposition(String.format("attachment; filename=\"%s\"; filename*=utf-8''%s", keyName, keyName));
        }
        if (!QSStringUtil.isEmpty(eTag)) {
            completeMultipartUploadInput.setETag(eTag);
        }
        RequestHandler requestHandler = this.bucket.completeMultipartUploadRequest(objectKey, completeMultipartUploadInput);
        this.sign(requestHandler);
        Bucket.CompleteMultipartUploadOutput send = (Bucket.CompleteMultipartUploadOutput)requestHandler.send();
        if (send.getStatueCode() == 200 || send.getStatueCode() == 201) {
            this.uploadModel.setUploadComplete(true);
            this.setData(objectKey, this.recorder);
        }
        if (this.callBack != null) {
            this.callBack.onAPIResponse(objectKey, send);
        }
    }

    public void putFile(File file, String objectKey, String fileName, long length) throws QSException {
        PutObjectInput input = new PutObjectInput();
        input.setContentLength(length);
        input.setBodyInputFile(file);
        if (!QSStringUtil.isEmpty(fileName)) {
            String keyName = UrlUtils.rfc3986UriEncode(fileName, true);
            input.setContentDisposition(String.format("attachment; filename=\"%s\"; filename*=utf-8''%s", keyName, keyName));
        }
        RequestHandler requestHandler = this.bucket.putObjectRequest(objectKey, input);
        if (this.progressListener != null) {
            requestHandler.setProgressListener((long len, long size) -> this.progressListener.onProgress(objectKey, len, size));
        }
        requestHandler.setCancellationHandler(this.cancellationHandler);
        this.sign(requestHandler);
        OutputModel outputModel = requestHandler.send();
        if (this.callBack != null) {
            this.callBack.onAPIResponse(objectKey, outputModel);
        }
    }

    public long getPartSize() {
        return this.partSize;
    }

    public void setPartSize(long partSize) {
        this.partSize = partSize;
    }

    public Recorder getRecorder() {
        return this.recorder;
    }

    public void setRecorder(Recorder recorder) {
        this.recorder = recorder;
    }

    public Bucket getBucket() {
        return this.bucket;
    }

    public void setBucket(Bucket bucket) {
        this.bucket = bucket;
    }

    public UploadProgressListener getProgressListener() {
        return this.progressListener;
    }

    public void setProgressListener(UploadProgressListener progressListener) {
        this.progressListener = progressListener;
    }

    public CancellationHandler getCancellationHandler() {
        return this.cancellationHandler;
    }

    public void setCancellationHandler(CancellationHandler cancellationHandler) {
        this.cancellationHandler = cancellationHandler;
    }

    public UploadManagerCallback getCallBack() {
        return this.callBack;
    }

    public void setCallBack(UploadManagerCallback callBack) {
        this.callBack = callBack;
    }

    public static class PutObjectInput
    extends Bucket.PutObjectInput {
        private String contentDisposition;

        public void setContentDisposition(String contentDisposition) {
            this.contentDisposition = contentDisposition;
        }

        @ParamAnnotation(paramType="header", paramName="content-disposition")
        public String getContentDisposition() {
            return this.contentDisposition;
        }
    }

    public static class CompleteMultipartUploadInput
    extends Bucket.CompleteMultipartUploadInput {
        private String contentDisposition;
        private Long contentLength;

        @ParamAnnotation(paramType="header", paramName="Content-Length")
        public Long getContentLength() {
            return this.contentLength;
        }

        public void setContentLength(Long contentLength) {
            this.contentLength = contentLength;
        }

        public void setContentDisposition(String contentDisposition) {
            this.contentDisposition = contentDisposition;
        }

        @ParamAnnotation(paramType="header", paramName="content-disposition")
        public String getContentDisposition() {
            return this.contentDisposition;
        }

        public CompleteMultipartUploadInput(String multipart_upload_id, int partsCount, int startIndex) {
            super(multipart_upload_id, partsCount, startIndex);
        }
    }
}

