/*
 * Decompiled with CFR 0.152.
 */
package com.qingstor.sdk.service;

import com.qingstor.sdk.annotation.ParamAnnotation;
import com.qingstor.sdk.common.OperationContext;
import com.qingstor.sdk.common.auth.Credentials;
import com.qingstor.sdk.config.ClientConfiguration;
import com.qingstor.sdk.config.EnvContext;
import com.qingstor.sdk.exception.QSException;
import com.qingstor.sdk.model.OutputModel;
import com.qingstor.sdk.model.RequestInputModel;
import com.qingstor.sdk.request.QSRequest;
import com.qingstor.sdk.request.RequestHandler;
import com.qingstor.sdk.request.ResponseCallBack;
import com.qingstor.sdk.service.Bucket;
import com.qingstor.sdk.service.Types;
import java.util.List;

public class QingStor {
    private String zone;
    private Credentials cred;
    private ClientConfiguration clientCfg;

    public QingStor(EnvContext envContext, String zone) {
        this.cred = envContext;
        this.clientCfg = ClientConfiguration.from(envContext);
        this.zone = zone;
    }

    public QingStor(EnvContext envContext) {
        this.cred = envContext;
        this.clientCfg = ClientConfiguration.from(envContext);
    }

    public Bucket getBucket(String bucketName, String zone) {
        return new Bucket(this.cred, this.clientCfg, zone, bucketName);
    }

    public ListBucketsOutput listBuckets(ListBucketsInput input) throws QSException {
        RequestHandler requestHandler;
        OutputModel backModel;
        if (input == null) {
            input = new ListBucketsInput();
        }
        if ((backModel = (requestHandler = this.listBucketsRequest(input)).send()) != null) {
            return (ListBucketsOutput)backModel;
        }
        return null;
    }

    public RequestHandler listBucketsRequest(ListBucketsInput input) throws QSException {
        if (input == null) {
            input = new ListBucketsInput();
        }
        OperationContext.OperationContextBuilder builder = OperationContext.builder();
        builder.clientCfg(this.clientCfg).zone(this.zone).credentials(this.cred).operationName("ListBuckets").apiName("ListBuckets").serviceName("Get Service").reqMethod("GET").subSourcePath("/");
        RequestHandler requestHandler = QSRequest.getRequest(builder.build(), input, ListBucketsOutput.class);
        return requestHandler;
    }

    public void listBucketsAsync(ListBucketsInput input, ResponseCallBack<ListBucketsOutput> callback) throws QSException {
        if (input == null) {
            input = new ListBucketsInput();
        }
        RequestHandler requestHandler = this.listBucketsAsyncRequest(input, callback);
        requestHandler.sendAsync();
    }

    public RequestHandler listBucketsAsyncRequest(ListBucketsInput input, ResponseCallBack<ListBucketsOutput> callback) throws QSException {
        if (input == null) {
            input = new ListBucketsInput();
        }
        OperationContext.OperationContextBuilder builder = OperationContext.builder();
        builder.clientCfg(this.clientCfg).zone(this.zone).credentials(this.cred).operationName("ListBuckets").apiName("ListBuckets").serviceName("Get Service").reqMethod("GET").subSourcePath("/");
        if (callback == null) {
            throw new QSException("callback can't be null");
        }
        RequestHandler requestHandler = QSRequest.getRequestAsync(builder.build(), input, callback);
        return requestHandler;
    }

    public static class ListBucketsOutput
    extends OutputModel {
        private List<Types.BucketModel> buckets;
        private Integer count;

        public void setBuckets(List<Types.BucketModel> buckets) {
            this.buckets = buckets;
        }

        @ParamAnnotation(paramType="element", paramName="buckets")
        public List<Types.BucketModel> getBuckets() {
            return this.buckets;
        }

        public void setCount(Integer count) {
            this.count = count;
        }

        @ParamAnnotation(paramType="element", paramName="count")
        public Integer getCount() {
            return this.count;
        }
    }

    public static class ListBucketsInput
    extends RequestInputModel {
        private Integer limit;
        private Integer offset;
        private String location;

        public void setLimit(Integer limit) {
            this.limit = limit;
        }

        @ParamAnnotation(paramType="query", paramName="limit")
        public Integer getLimit() {
            return this.limit;
        }

        public void setOffset(Integer offset) {
            this.offset = offset;
        }

        @ParamAnnotation(paramType="query", paramName="offset")
        public Integer getOffset() {
            return this.offset;
        }

        public void setLocation(String location) {
            this.location = location;
        }

        @ParamAnnotation(paramType="header", paramName="location")
        public String getLocation() {
            return this.location;
        }

        @Override
        public String validateParam() {
            return null;
        }
    }
}

