/*
 * Decompiled with CFR 0.152.
 */
package com.qingstor.sdk.request;

import com.qingstor.sdk.config.EnvContext;
import com.qingstor.sdk.constants.QSConstant;
import com.qingstor.sdk.exception.QSException;
import com.qingstor.sdk.model.OutputModel;
import com.qingstor.sdk.request.CancellationHandler;
import com.qingstor.sdk.request.ResponseCallBack;
import com.qingstor.sdk.utils.QSJSONUtil;
import com.qingstor.sdk.utils.QSParamInvokeUtil;
import com.qingstor.sdk.utils.QSStringUtil;
import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Headers;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.Util;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QSOkHttpRequestClient {
    private static final Logger log = LoggerFactory.getLogger(QSOkHttpRequestClient.class);
    private final OkHttpClient client;
    private static volatile QSOkHttpRequestClient ins;

    protected QSOkHttpRequestClient(EnvContext ctx) {
        int readTimeout = ctx.getHttpConfig().getReadTimeout();
        int writeTimeout = ctx.getHttpConfig().getWriteTimeout();
        int connectionTimeout = ctx.getHttpConfig().getConnectionTimeout();
        this.client = new OkHttpClient.Builder().connectTimeout((long)connectionTimeout, TimeUnit.SECONDS).readTimeout((long)readTimeout, TimeUnit.SECONDS).writeTimeout((long)writeTimeout, TimeUnit.SECONDS).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static QSOkHttpRequestClient getInstance(EnvContext ctx) {
        if (ins != null) return ins;
        Class<QSOkHttpRequestClient> clazz = QSOkHttpRequestClient.class;
        synchronized (QSOkHttpRequestClient.class) {
            if (ins != null) return ins;
            ins = new QSOkHttpRequestClient(ctx);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return ins;
        }
    }

    public OutputModel requestAction(Request request, boolean bSafe, Class<? extends OutputModel> outputClass) throws QSException {
        Call okhttpCall = this.client.newCall(request);
        OutputModel model = QSParamInvokeUtil.getOutputModel(outputClass);
        try {
            Response response = okhttpCall.execute();
            this.fillResponseValue2Object(response, model);
            return model;
        }
        catch (Exception e) {
            if (e instanceof CancellationHandler.CancellationException) {
                QSOkHttpRequestClient.fillResponseCallbackModel(20000, e.getMessage(), model);
                return model;
            }
            e.printStackTrace();
            log.error(e.getMessage());
            throw new QSException(e.getMessage());
        }
    }

    public OutputModel requestActionAsync(Request request, boolean bSafe, final ResponseCallBack callBack) {
        Call okhttpCall = this.client.newCall(request);
        okhttpCall.enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                QSOkHttpRequestClient.this.onOkhttpFailure(e, callBack);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onResponse(Call call, Response response) {
                try {
                    if (callBack != null) {
                        OutputModel m = QSParamInvokeUtil.getOutputModel(callBack);
                        QSOkHttpRequestClient.this.fillResponseValue2Object(response, m);
                        callBack.onAPIResponse(m);
                    }
                }
                catch (Exception e) {
                    log.error(e.getMessage());
                    QSOkHttpRequestClient.this.onOkhttpFailure(e, callBack);
                }
                finally {
                    Util.closeQuietly((Closeable)response.body().source());
                }
            }
        });
        return null;
    }

    private void onOkhttpFailure(Exception e, ResponseCallBack callBack) {
        try {
            if (callBack != null) {
                int errorCode = 10000;
                if (e instanceof CancellationHandler.CancellationException) {
                    errorCode = 20000;
                }
                OutputModel m = QSParamInvokeUtil.getOutputModel(callBack);
                QSOkHttpRequestClient.fillResponseCallbackModel(errorCode, e.getMessage(), m);
                callBack.onAPIResponse(m);
            }
        }
        catch (Exception ex) {
            log.error(ex.getMessage());
        }
    }

    public static void fillResponseCallbackModel(int code, Object content, OutputModel model) {
        HashMap<String, Object> errorMap = new HashMap<String, Object>();
        errorMap.put(QSConstant.QC_CODE_FIELD_NAME, code);
        errorMap.put(QSConstant.QC_MESSAGE_FIELD_NAME, content);
        QSJSONUtil.jsonFillValue2Object(QSStringUtil.getObjectToJson(errorMap), model);
    }

    private void fillResponseValue2Object(Response response, OutputModel target) throws IOException {
        int code = response.code();
        ResponseBody body = response.body();
        JSONObject o = QSJSONUtil.toJSONObject("{}");
        QSJSONUtil.putJsonData(o, "BodyInputStream", (Object)body.source().inputStream());
        if (target != null) {
            String responseInfo;
            boolean binaryBody = false;
            if (response.isSuccessful()) {
                binaryBody = QSJSONUtil.jsonObjFillValue2Object(o, target);
            }
            if (!binaryBody && !QSStringUtil.isEmpty(responseInfo = body.string())) {
                QSJSONUtil.jsonFillValue2Object(responseInfo, target);
            }
            Headers headers = response.headers();
            JSONObject headJson = QSJSONUtil.toJSONObject("{}");
            QSJSONUtil.putJsonData(headJson, QSConstant.QC_CODE_FIELD_NAME, (Object)code);
            for (int i = 0; i < headers.size(); ++i) {
                String key = headers.name(i).toLowerCase();
                QSJSONUtil.putJsonData(headJson, key, (Object)headers.value(i));
            }
            QSJSONUtil.jsonObjFillValue2Object(headJson, target);
        }
    }

    @Deprecated
    public static Request buildRequest(String method, String url, RequestBody body, Map headers) {
        String[] sortedHeadersKeys;
        Request.Builder builder = new Request.Builder();
        for (String key : sortedHeadersKeys = headers.keySet().toArray(new String[0])) {
            builder.addHeader(key, String.valueOf(headers.get(key)));
        }
        return builder.url(url).method(method, body).build();
    }

    @Deprecated
    public static Request buildUrlRequest(String signedUrl) {
        return new Request.Builder().url(signedUrl).build();
    }

    @Deprecated
    public OkHttpClient getSafetyClient() {
        return this.client;
    }
}

