/*
 * Decompiled with CFR 0.152.
 */
package com.qingstor.sdk.config;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.qingstor.sdk.common.auth.Credentials;
import com.qingstor.sdk.exception.QSException;
import com.qingstor.sdk.request.ParamValidate;
import com.qingstor.sdk.utils.QSStringUtil;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.EnumMap;

@JsonIgnoreProperties(ignoreUnknown=true)
public class EnvContext
implements ParamValidate,
Credentials {
    private static final ObjectMapper om;
    private static final HttpConfig DEFAULT_HTTP_CONFIG;
    private static final String DEFAULT_ENDPOINT = "https://qingstor.com";
    @Deprecated
    private static final String DEFAULT_HOST = "qingstor.com";
    @Deprecated
    private static final String DEFAULT_PROTOCOL = "https";
    private String accessKeyId;
    private String secretAccessKey;
    private String endpoint = "https://qingstor.com";
    private String additionalUserAgent;
    @JsonProperty(value="enable_virtual_host_style")
    @JsonAlias(value={"virtual_host_enabled"})
    private boolean virtualHostEnabled = false;
    private boolean cnameSupport = false;
    private HttpConfig httpConfig = DEFAULT_HTTP_CONFIG;
    @Deprecated
    private String requestUrlStyle = "virtual_host_style";
    @Deprecated
    private String host = "qingstor.com";
    @Deprecated
    private String port;
    @Deprecated
    private String protocol = "https";
    @Deprecated
    private boolean safeOkHttp = true;

    private EnvContext() {
    }

    public EnvContext(String accessKey, String accessSecret) {
        this.setAccessKeyId(accessKey);
        this.setSecretAccessKey(accessSecret);
    }

    public static EnvContext loadUserConfig() throws QSException {
        String configPath = System.getenv(Env.CONFIG_PATH.toString());
        if (configPath == null) {
            configPath = System.getProperty("user.home") + "/.config/qingstor.yaml";
        }
        return EnvContext.loadFromFile(configPath);
    }

    public static EnvContext loadFromFile(String filepath) throws QSException {
        EnvContext envCtx;
        try {
            envCtx = (EnvContext)om.readValue(new File(filepath), EnvContext.class);
        }
        catch (IOException e) {
            throw new QSException(e.getMessage());
        }
        EnumMap<Env, String> envs = new EnumMap<Env, String>(Env.class);
        for (Env env : Env.values()) {
            String value = System.getenv(env.toString());
            if (value == null) continue;
            envs.put(env, value);
        }
        String ak = (String)envs.get((Object)Env.ACCESS_KEY_ID);
        String sk = (String)envs.get((Object)Env.SECRET_ACCESS_KEY);
        if (ak != null) {
            envCtx.setAccessKeyId(ak);
        }
        if (sk != null) {
            envCtx.setSecretAccessKey(sk);
        }
        return envCtx;
    }

    public boolean isVirtualHostEnabled() {
        return this.virtualHostEnabled;
    }

    public void setVirtualHostEnabled(boolean virtualHostEnabled) {
        this.virtualHostEnabled = virtualHostEnabled;
    }

    @Override
    public String getAccessKeyId() {
        return this.accessKeyId;
    }

    public void setAccessKeyId(String accessKeyId) {
        this.accessKeyId = accessKeyId;
    }

    @Override
    public String getSecretAccessKey() {
        return this.secretAccessKey;
    }

    public void setSecretAccessKey(String secretAccessKey) {
        this.secretAccessKey = secretAccessKey;
    }

    public URI getEndpoint() {
        boolean useOldCfg = false;
        if (!this.getProtocol().equals(DEFAULT_PROTOCOL) || !this.getHost().equals(DEFAULT_HOST)) {
            useOldCfg = true;
        }
        if (!useOldCfg) {
            return URI.create(this.endpoint);
        }
        String joinUrl = this.getProtocol() + "://" + this.getHost();
        if (this.getPort() != null) {
            joinUrl = joinUrl + ":" + this.getPort();
        }
        return URI.create(joinUrl);
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getAdditionalUserAgent() {
        return this.additionalUserAgent;
    }

    public void setAdditionalUserAgent(String additionalUserAgent) {
        this.additionalUserAgent = additionalUserAgent;
    }

    public boolean isCnameSupport() {
        return this.cnameSupport;
    }

    public void setCnameSupport(boolean cnameSupport) {
        this.cnameSupport = cnameSupport;
    }

    public HttpConfig getHttpConfig() {
        return this.httpConfig;
    }

    public void setHttpConfig(HttpConfig httpConfig) {
        this.httpConfig = httpConfig;
    }

    @Override
    public String validateParam() {
        if (QSStringUtil.isEmpty(this.getAccessKeyId())) {
            return QSStringUtil.getParameterRequired("AccessKeyId", "EnvContext");
        }
        if (QSStringUtil.isEmpty(this.getEndpoint().toString())) {
            return QSStringUtil.getParameterRequired("host", "EnvContext");
        }
        if (!QSStringUtil.isEmpty(this.getAdditionalUserAgent())) {
            for (int i = 0; i < this.getAdditionalUserAgent().length(); ++i) {
                char temp = this.getAdditionalUserAgent().charAt(i);
                if (temp >= ' ' && temp <= '~' && temp != ' ' && temp != '\"') continue;
                return "Additional User-Agent contains characters that not allowed :" + this.getAdditionalUserAgent().charAt(i);
            }
        }
        return null;
    }

    public String toString() {
        return "EnvContext{accessKeyId='" + this.accessKeyId + '\'' + ", secretAccessKey='" + this.secretAccessKey + '\'' + ", host='" + this.host + '\'' + ", port='" + this.port + '\'' + ", protocol='" + this.protocol + '\'' + ", additionalUserAgent='" + this.additionalUserAgent + '\'' + ", requestUrlStyle='" + this.requestUrlStyle + '\'' + ", httpConfig=" + this.httpConfig + ", safeOkHttp=" + this.safeOkHttp + '}';
    }

    @Deprecated
    public String getHost() {
        return this.host;
    }

    @Deprecated
    public void setHost(String host) {
        this.host = host;
    }

    @Deprecated
    public String getPort() {
        return this.port;
    }

    @Deprecated
    public void setPort(String port) {
        this.port = port;
    }

    @Deprecated
    public String getProtocol() {
        return this.protocol;
    }

    @Deprecated
    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getRequestUrl() {
        String joinUrl = this.getProtocol() + "://" + this.getHost();
        if (this.getPort() != null) {
            joinUrl = joinUrl + ":" + this.getPort();
        }
        return joinUrl;
    }

    @Deprecated
    public String getRequestUrlStyle() {
        return this.requestUrlStyle;
    }

    @Deprecated
    public void setRequestUrlStyle(String requestUrlStyle) {
        this.requestUrlStyle = requestUrlStyle;
    }

    @Deprecated
    public boolean isSafeOkHttp() {
        return this.safeOkHttp;
    }

    @Deprecated
    public void setSafeOkHttp(boolean safeOkHttp) {
        this.safeOkHttp = safeOkHttp;
    }

    static {
        DEFAULT_HTTP_CONFIG = new HttpConfig();
        om = new ObjectMapper((JsonFactory)new YAMLFactory());
        om.setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE);
    }

    public static class HttpConfig {
        private int readTimeout = 100;
        private int connectionTimeout = 60;
        private int writeTimeout = 100;

        public HttpConfig() {
        }

        public HttpConfig(int readTimeout, int connectionTimeout, int writeTimeout) {
            this.readTimeout = readTimeout;
            this.connectionTimeout = connectionTimeout;
            this.writeTimeout = writeTimeout;
        }

        public int getReadTimeout() {
            return this.readTimeout;
        }

        public void setReadTimeout(int readTimeout) {
            this.readTimeout = readTimeout;
        }

        public int getConnectionTimeout() {
            return this.connectionTimeout;
        }

        public void setConnectionTimeout(int connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
        }

        public int getWriteTimeout() {
            return this.writeTimeout;
        }

        public void setWriteTimeout(int writeTimeout) {
            this.writeTimeout = writeTimeout;
        }
    }

    private static enum Env {
        CONFIG_PATH("QINGSTOR_CONFIG_PATH"),
        ACCESS_KEY_ID("QINGSTOR_ACCESS_KEY_ID"),
        SECRET_ACCESS_KEY("QINGSTOR_SECRET_ACCESS_KEY");

        private final String env;

        private Env(String env) {
            this.env = env;
        }

        public String toString() {
            return this.env;
        }
    }
}

