/*
 * Decompiled with CFR 0.152.
 */
package com.qingstor.sdk.config;

import com.qingstor.sdk.config.EnvContext;
import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ClientConfiguration {
    private static final Pattern IPV4_LIKE = Pattern.compile("^\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}$");
    private final URI endpoint;
    private final boolean cnameSupport;
    private final Set<String> cnameExcludeSet;
    private final String userAgent;
    private final boolean virtualHostEnabled;
    @Deprecated
    private final boolean safeOkHttp;
    private final int readTimeout;
    private final int connTimeout;
    private final int writeTimeout;
    private final boolean rawHost;

    ClientConfiguration(URI endpoint, boolean cnameSupport, Set<String> cnameExcludeSet, String userAgent, boolean virtualHostEnabled, boolean safeOkHttp, int readTimeout, int connTimeout, int writeTimeout) {
        this.endpoint = endpoint;
        this.userAgent = userAgent;
        this.cnameSupport = cnameSupport;
        this.cnameExcludeSet = cnameExcludeSet;
        this.safeOkHttp = safeOkHttp;
        this.readTimeout = readTimeout;
        this.connTimeout = connTimeout;
        this.writeTimeout = writeTimeout;
        this.rawHost = ClientConfiguration.isIpOrLocalhost(this.endpoint);
        this.virtualHostEnabled = !this.rawHost && virtualHostEnabled;
    }

    private static boolean isIpOrLocalhost(URI uri) {
        String host = uri.getHost();
        if (host.equals("localhost")) {
            return true;
        }
        Matcher matcher = IPV4_LIKE.matcher(host);
        return matcher.matches() || host.startsWith("[");
    }

    public static ClientConfigurationBuilder builder() {
        return new ClientConfigurationBuilder();
    }

    public static ClientConfiguration from(EnvContext env) {
        ClientConfigurationBuilder builder = ClientConfiguration.builder();
        return builder.userAgent(env.getAdditionalUserAgent()).safeOkHttp(env.isSafeOkHttp()).virtualHostEnabled(env.isVirtualHostEnabled()).supportCname(env.isCnameSupport()).endpoint(env.getEndpoint()).build();
    }

    public URI endpoint() {
        return this.endpoint;
    }

    public String userAgent() {
        return this.userAgent;
    }

    public boolean isVirtualHostEnabled() {
        return this.virtualHostEnabled;
    }

    public boolean isCnameSupport() {
        return this.cnameSupport;
    }

    public Set<String> cnameExcludeSet() {
        return Collections.unmodifiableSet(this.cnameExcludeSet);
    }

    public boolean isRawHost() {
        return this.rawHost;
    }

    @Deprecated
    public boolean isSafeOkHttp() {
        return this.safeOkHttp;
    }

    public int readTimeout() {
        return this.readTimeout;
    }

    public int connTimeout() {
        return this.connTimeout;
    }

    public int writeTimeout() {
        return this.writeTimeout;
    }

    public String toString() {
        return "ClientConfiguration{endpoint=" + this.endpoint + ", supportCname=" + this.cnameSupport + ", userAgent='" + this.userAgent + '\'' + ", virtualHostEnabled=" + this.virtualHostEnabled + ", safeOkHttp=" + this.safeOkHttp + ", readTimeout=" + this.readTimeout + ", connTimeout=" + this.connTimeout + ", writeTimeout=" + this.writeTimeout + '}';
    }

    public static class ClientConfigurationBuilder {
        public static final String DEFAULT_CNAME_EXCLUDE_LIST = "qingstor.com";
        private static final String DEFAULT_HOST = "qingstor.com";
        private static final String DEFAULT_PROTOCOL = "https";
        private static final int READ_TIMEOUT = 100;
        private static final int CONN_TIMEOUT = 60;
        private static final int WRITE_TIMEOUT = 100;
        private URI endpoint = URI.create("https://qingstor.com");
        private String userAgent;
        private boolean virtualHostEnabled;
        private boolean supportCname;
        private Set<String> cnameExcludeSet = new HashSet<String>();
        private boolean safeOkHttp = true;
        private int readTimeout = 100;
        private int connTimeout = 60;
        private int writeTimeout = 100;

        ClientConfigurationBuilder() {
        }

        public ClientConfigurationBuilder endpoint(URI endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public ClientConfigurationBuilder readTimeout(int readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        public ClientConfigurationBuilder connTimeout(int connTimeout) {
            this.connTimeout = connTimeout;
            return this;
        }

        public ClientConfigurationBuilder writeTimeout(int writeTimeout) {
            this.writeTimeout = writeTimeout;
            return this;
        }

        public ClientConfigurationBuilder userAgent(String userAgent) {
            this.userAgent = userAgent;
            return this;
        }

        public ClientConfigurationBuilder virtualHostEnabled(boolean virtualHostEnabled) {
            this.virtualHostEnabled = virtualHostEnabled;
            return this;
        }

        public ClientConfigurationBuilder supportCname(boolean supportCname) {
            this.supportCname = supportCname;
            return this;
        }

        public ClientConfigurationBuilder cnameExcludeSet(Set<String> cnameExcludeSet) {
            if (cnameExcludeSet == null) {
                throw new IllegalArgumentException("cname exclude set should not be null.");
            }
            this.cnameExcludeSet.clear();
            for (String excl : cnameExcludeSet) {
                if (excl.trim().isEmpty()) continue;
                this.cnameExcludeSet.add(excl);
            }
            ClientConfigurationBuilder.appendDefaultExcludeSet(this.cnameExcludeSet);
            return this;
        }

        public ClientConfiguration build() {
            ClientConfigurationBuilder.appendDefaultExcludeSet(this.cnameExcludeSet);
            return new ClientConfiguration(this.endpoint, this.supportCname, this.cnameExcludeSet, this.userAgent, this.virtualHostEnabled, this.safeOkHttp, this.readTimeout, this.connTimeout, this.writeTimeout);
        }

        private static void appendDefaultExcludeSet(Set<String> excludeSet) {
            String[] excludes;
            for (String excl : excludes = "qingstor.com".split(",")) {
                if (excl.trim().isEmpty() || excludeSet.contains(excl)) continue;
                excludeSet.add(excl.trim().toLowerCase());
            }
        }

        @Deprecated
        public ClientConfigurationBuilder safeOkHttp(boolean safeOkHttp) {
            this.safeOkHttp = safeOkHttp;
            return this;
        }
    }
}

