/*
 * Decompiled with CFR 0.152.
 */
package com.ochafik.lang.reflect;

import com.ochafik.io.StringBufferOutputStream;
import com.ochafik.lang.AssertUtils;
import java.io.PrintStream;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DebugUtils {
    public static final void print(Object o, FieldAccessor accessor) {
        DebugUtils.print(o, System.out, false, false, "", accessor);
    }

    public static final void printErr(Object o, FieldAccessor accessor) {
        DebugUtils.print(o, System.err, false, false, "", accessor);
    }

    public static final void println(Object o, FieldAccessor accessor) {
        DebugUtils.print(o, System.out, true, false, "", accessor);
    }

    public static final void printlnErr(Object o, FieldAccessor accessor) {
        DebugUtils.print(o, System.err, true, false, "", accessor);
    }

    public static final void print(Object o) {
        DebugUtils.print(o, System.out, false, false, "", null);
    }

    public static final void printErr(Object o) {
        DebugUtils.print(o, System.err, false, false, "", null);
    }

    public static final void println(Object o) {
        DebugUtils.print(o, System.out, true, false, "", null);
    }

    public static final void println(Object o, PrintStream out) {
        DebugUtils.print(o, out, true, false, "", null);
    }

    public static final void printlnErr(Object o) {
        DebugUtils.print(o, System.err, true, false, "", null);
    }

    protected static String escape(String s) {
        return s.replace("\\", "\\\\").replace("\"", "\\\"").replace("\n", "\\n").replace("\t", "\\t").replace("\r", "");
    }

    public static final void printAsCharSequence(CharSequence o, PrintStream out, boolean lines, boolean startIndent, String indent, FieldAccessor accessor) {
        out.print('\"');
        out.print(DebugUtils.escape(o.toString()));
        out.print('\"');
        if (lines) {
            out.println();
        }
    }

    public static final void printStructureInsides(Object o, PrintStream out, boolean lines, boolean startIndent, String indent, FieldAccessor accessor) {
        Class<?> type = o.getClass();
        Set<Field> fields = DebugUtils.getFields(type);
        int i = 0;
        for (Field f : fields) {
            Object v;
            boolean inaccessibleValue = false;
            try {
                v = accessor == null ? f.get(o) : accessor.access(f, o);
            }
            catch (IllegalAccessException ex) {
                String fn = f.getName();
                try {
                    Method m = type.getMethod("get" + fn.substring(0, 1).toUpperCase() + fn.substring(1), new Class[0]);
                    v = m.invoke(o, new Object[0]);
                }
                catch (Exception e) {
                    inaccessibleValue = true;
                    v = null;
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (lines) {
                out.print(indent);
            } else if (i++ != 0) {
                out.print("; ");
            }
            out.print(f.getName());
            out.print(" = ");
            if (inaccessibleValue) {
                out.print('?');
                continue;
            }
            DebugUtils.print(v, out, lines, false, indent, accessor);
        }
    }

    public static final void print(Object o, PrintStream out, boolean lines, boolean startIndent, String indent, FieldAccessor accessor) {
        if (lines && startIndent) {
            out.print(indent);
        }
        if (o == null) {
            out.print(o);
            if (lines) {
                out.println();
            }
            return;
        }
        Class<?> type = o.getClass();
        boolean isCollection = o instanceof Collection;
        if (o instanceof CharSequence) {
            out.print('\"');
            out.print(DebugUtils.escape(o.toString()));
            out.print('\"');
            if (lines) {
                out.println();
            }
            return;
        }
        if (type == Character.class) {
            out.print('\'');
            out.print(DebugUtils.escape(o.toString()));
            out.print('\'');
            if (lines) {
                out.println();
            }
            return;
        }
        if (!isCollection && DebugUtils.hasToStringMethod(type)) {
            out.print(o);
            if (lines) {
                out.println();
            }
            return;
        }
        out.print(type.getSimpleName());
        out.print(" {");
        if (lines) {
            out.println();
        }
        String newIndent = indent + "\t";
        if (type.isArray()) {
            int n = Array.getLength(o);
            for (int i = 0; i < n; ++i) {
                if (!lines && i != 0) {
                    out.print(", ");
                }
                DebugUtils.print(Array.get(o, i), out, lines, true, newIndent, accessor);
            }
        } else if (isCollection) {
            int i = 0;
            for (Object e : (Collection)o) {
                if (!lines && i++ != 0) {
                    out.print(", ");
                }
                DebugUtils.print(e, out, lines, true, newIndent, accessor);
            }
        } else {
            DebugUtils.printStructureInsides(o, out, lines, startIndent, newIndent, accessor);
        }
        if (lines) {
            out.print(indent);
        }
        out.print("}");
        if (lines) {
            out.println();
        }
    }

    public static Set<Field> getFields(Class<?> type) {
        TreeSet<Field> fields = new TreeSet<Field>(new Comparator<Field>(){

            @Override
            public int compare(Field o1, Field o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        fields.addAll(Arrays.asList(type.getFields()));
        do {
            fields.addAll(Arrays.asList(type.getDeclaredFields()));
        } while ((type = type.getSuperclass()) != null);
        return fields;
    }

    protected static void getFields_aux(Class<?> type, Set<Field> fields) {
    }

    public static boolean hasToStringMethod(Class<?> c) {
        if (c == Object.class) {
            return false;
        }
        for (Method m : c.getDeclaredMethods()) {
            if (!m.getName().equals("toString") || m.getParameterTypes().length != 0) continue;
            return true;
        }
        return DebugUtils.hasToStringMethod(c.getSuperclass());
    }

    public static void main(String[] args) {
        DebugUtils.println((Object)new Object[]{new AssertUtils.Test()}, new FieldAccessor(){

            public Object access(Field f, Object target) throws IllegalArgumentException, IllegalAccessException {
                return f.get(target);
            }
        });
    }

    public static String toString(Object object) {
        StringBufferOutputStream out = new StringBufferOutputStream();
        DebugUtils.print(object, new PrintStream(out), false, false, "", null);
        return out.toString();
    }

    public static abstract class FieldAccessor {
        public abstract Object access(Field var1, Object var2) throws IllegalArgumentException, IllegalAccessException;
    }
}

