package com.icetech.start.xxljob;

import com.xxl.job.core.executor.impl.XxlJobSpringExecutor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@ConditionalOnClass(XxlJobSpringExecutor.class)
@EnableConfigurationProperties(XxlJobProperties.class)
public class XxlJobConfiguration {

  @Autowired
  XxlJobProperties xxlJobProperties;



  @Bean(initMethod = "start", destroyMethod = "destroy")
  @ConditionalOnMissingBean
  public XxlJobSpringExecutor xxlJobExecutor() {
    XxlJobSpringExecutor xxlJobSpringExecutor = new XxlJobSpringExecutor();
    xxlJobSpringExecutor.setAdminAddresses(xxlJobProperties.getAdminAddresses());
    xxlJobSpringExecutor.setAppname(xxlJobProperties.getExecutorAppName());
    xxlJobSpringExecutor.setIp(xxlJobProperties.getExecutorIp());
    xxlJobSpringExecutor.setPort(xxlJobProperties.getExecutorPort());
    xxlJobSpringExecutor.setAccessToken(xxlJobProperties.getExecutorAccessToken());
    xxlJobSpringExecutor.setLogPath(xxlJobProperties.getExecutorLogPath());
    xxlJobSpringExecutor.setLogRetentionDays(xxlJobProperties.getExecutorLogRetentionDays());

    return xxlJobSpringExecutor;
  }
}
