/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.pay.util;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IcepayKit {
    private static final Logger log = LoggerFactory.getLogger(IcepayKit.class);
    private static String encodingCharset = "UTF-8";

    public static String getStrSort(Map<String, Object> map) {
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (null == entry.getValue() || "".equals(entry.getValue())) continue;
            list.add(entry.getKey() + "=" + entry.getValue() + "&");
        }
        int size = list.size();
        String[] arrayToSort = list.toArray(new String[size]);
        Arrays.sort(arrayToSort, String.CASE_INSENSITIVE_ORDER);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            sb.append(arrayToSort[i]);
        }
        return sb.toString();
    }

    public static String getSign(Map<String, Object> map, String key) {
        String result = IcepayKit.getStrSort(map);
        result = result + "key=" + key;
        if (log.isDebugEnabled()) {
            log.debug("signStr:{}", (Object)result);
        }
        result = IcepayKit.md5(result, encodingCharset).toUpperCase();
        if (log.isDebugEnabled()) {
            log.debug("signValue:{}", (Object)result);
        }
        return result;
    }

    public static String getSign(String signStr, String key) {
        signStr = signStr + "key=" + key;
        String result = IcepayKit.md5(signStr, encodingCharset).toUpperCase();
        return result;
    }

    public static String getSign(String signStr) {
        return IcepayKit.md5(signStr, encodingCharset).toUpperCase();
    }

    public static String md5(String value, String charset) {
        MessageDigest md = null;
        try {
            byte[] data = value.getBytes(charset);
            md = MessageDigest.getInstance("MD5");
            byte[] digestData = md.digest(data);
            return IcepayKit.toHex(digestData);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String toHex(byte[] input) {
        if (input == null) {
            return null;
        }
        StringBuffer output = new StringBuffer(input.length * 2);
        for (int i = 0; i < input.length; ++i) {
            int current = input[i] & 0xFF;
            if (current < 16) {
                output.append("0");
            }
            output.append(Integer.toString(current, 16));
        }
        return output.toString();
    }
}

