/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.pay.net;

import com.icetech.pay.exception.APIConnectionException;
import com.icetech.pay.net.APIIcepayRequest;
import com.icetech.pay.net.APIIcepayResponse;
import com.icetech.pay.net.APIResource;
import com.icetech.pay.net.HttpClient;
import com.icetech.pay.net.HttpHeaders;
import com.icetech.pay.util.StreamUtils;
import com.icetech.pay.util.StringUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HttpURLConnectionClient
extends HttpClient {
    @Override
    public APIIcepayResponse request(APIIcepayRequest request) throws APIConnectionException {
        HttpURLConnection conn = null;
        try {
            conn = HttpURLConnectionClient.createIcepayConnection(request);
            int responseCode = conn.getResponseCode();
            HttpHeaders headers = HttpHeaders.of(conn.getHeaderFields());
            String responseBody = responseCode >= 200 && responseCode < 300 ? StreamUtils.readToEnd(conn.getInputStream(), APIResource.CHARSET) : StreamUtils.readToEnd(conn.getErrorStream(), APIResource.CHARSET);
            APIIcepayResponse aPIIcepayResponse = new APIIcepayResponse(responseCode, responseBody, headers);
            return aPIIcepayResponse;
        }
        catch (IOException e) {
            throw new APIConnectionException(String.format("\u7487\u950b\u7730Icepay(%s)\u5bee\u509a\u7236,\u7487\u950b\ue5c5\u93cc\u30e7\u7d89\u7f01\u6ec4\u57a8\u95b2\u5d88\u762f.\u5bee\u509a\u7236\u6dc7\u2103\u4f05:%s", request.getUrl(), e.getMessage()), e);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    static HttpHeaders getHeaders(APIIcepayRequest request) {
        HashMap<String, List<String>> userAgentHeadersMap = new HashMap<String, List<String>>();
        userAgentHeadersMap.put("User-Agent", Collections.singletonList(HttpURLConnectionClient.buildUserAgentString(request.getOptions().getVersion())));
        userAgentHeadersMap.put("X-Icepay-Client-User-Agent", Collections.singletonList(HttpURLConnectionClient.buildXIcepayClientUserAgentString(request.getOptions().getVersion())));
        return request.getHeaders().withAdditionalHeaders(userAgentHeadersMap);
    }

    private static HttpURLConnection createIcepayConnection(APIIcepayRequest request) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)request.url.openConnection();
        conn.setConnectTimeout(request.options.getConnectTimeout());
        conn.setReadTimeout(request.options.getReadTimeout());
        conn.setUseCaches(false);
        for (Map.Entry<String, List<String>> entry : HttpURLConnectionClient.getHeaders(request).map().entrySet()) {
            conn.setRequestProperty(entry.getKey(), StringUtils.join(",", entry.getValue()));
        }
        conn.setRequestMethod(request.method.name());
        if (request.content != null) {
            conn.setDoOutput(true);
            conn.setRequestProperty("Content-Type", request.content.contentType);
            try (OutputStream output = conn.getOutputStream();){
                output.write(request.content.byteArrayContent);
            }
        }
        return conn;
    }
}

