/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.pay.net;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.icetech.pay.exception.APIException;
import com.icetech.pay.exception.IcepayException;
import com.icetech.pay.exception.InvalidRequestException;
import com.icetech.pay.net.APIIcepayRequest;
import com.icetech.pay.net.APIIcepayResponse;
import com.icetech.pay.net.HttpClient;
import com.icetech.pay.net.HttpURLConnectionClient;
import com.icetech.pay.request.IcepayRequest;
import com.icetech.pay.response.IcepayResponse;
import com.icetech.pay.util.JSONWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class APIResource {
    private static final Logger log = LoggerFactory.getLogger(APIResource.class);
    public static final Charset CHARSET = StandardCharsets.UTF_8;
    private static HttpClient httpClient = new HttpURLConnectionClient();

    public static Class<?> getSelfClass() {
        return APIResource.class;
    }

    protected static String urlEncode(String str) {
        if (str == null) {
            return null;
        }
        try {
            return URLEncoder.encode(str, CHARSET.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)"UTF-8 is unknown");
        }
    }

    public <T extends IcepayResponse> T execute(IcepayRequest<T> request, RequestMethod method, String url) throws IcepayException {
        String jsonParam = new JSONWriter().write(request.getBizModel(), true);
        JSONObject params = JSONObject.parseObject((String)jsonParam);
        request.getRequestOptions();
        APIIcepayRequest apiIcepayRequest = new APIIcepayRequest(method, url, (Map<String, Object>)params, request.getRequestOptions());
        if (log.isDebugEnabled()) {
            log.debug("Icepay_SDK_REQ\u951b\u6b76rl={}, data={}", (Object)apiIcepayRequest.getUrl(), (Object)JSONObject.toJSONString(apiIcepayRequest.getParams()));
        }
        APIIcepayResponse response = httpClient.requestWithRetries(apiIcepayRequest);
        int responseCode = response.getResponseCode();
        String responseBody = response.getResponseBody();
        if (log.isDebugEnabled()) {
            log.debug("Icepay_SDK_RES\u951b\u6b5dode={}, body={}", (Object)responseCode, (Object)responseBody);
        }
        if (responseCode != 200) {
            APIResource.handleAPIError(response);
        }
        IcepayResponse resource = null;
        try {
            resource = (IcepayResponse)JSONObject.parseObject((String)responseBody, request.getResponseClass());
        }
        catch (JSONException e) {
            APIResource.raiseMalformedJsonError(responseBody, responseCode);
        }
        return (T)resource;
    }

    private static void handleAPIError(APIIcepayResponse response) throws IcepayException {
        String rBody = response.getResponseBody();
        int rCode = response.getResponseCode();
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject = JSONObject.parseObject((String)rBody);
        }
        catch (JSONException e) {
            APIResource.raiseMalformedJsonError(rBody, rCode);
        }
        if (rCode == 404) {
            throw new InvalidRequestException(jsonObject.getString("status") + ", " + jsonObject.getString("error") + ", " + jsonObject.getString("path"), rCode, null);
        }
    }

    private static void raiseMalformedJsonError(String responseBody, int responseCode) throws APIException {
        throw new APIException(String.format("Invalid response object from API: %s. (HTTP response code was %d)", responseBody, responseCode), null, null, responseCode, null);
    }

    protected static enum RequestMethod {
        GET,
        POST,
        DELETE,
        PUT;

    }
}

