/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.pay.net;

import com.icetech.pay.exception.APIConnectionException;
import com.icetech.pay.exception.IcepayException;
import com.icetech.pay.net.APIResource;
import com.icetech.pay.net.HttpContent;
import com.icetech.pay.net.HttpHeaders;
import com.icetech.pay.net.RequestOptions;
import com.icetech.pay.util.IcepayKit;
import com.icetech.pay.util.StringUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class APIIcepayRequest {
    APIResource.RequestMethod method;
    URL url;
    HttpContent content;
    HttpHeaders headers;
    Map<String, Object> params;
    RequestOptions options;

    public APIIcepayRequest(APIResource.RequestMethod method, String url, Map<String, Object> params, RequestOptions options) throws IcepayException {
        try {
            this.params = params != null ? Collections.unmodifiableMap(params) : null;
            this.options = options;
            this.method = method;
            this.url = APIIcepayRequest.buildURL(method, StringUtils.genUrl(url, this.options.getUri()), params);
            this.content = APIIcepayRequest.buildContent(method, params, this.options);
            this.headers = APIIcepayRequest.buildHeaders(method, this.options);
        }
        catch (IOException e) {
            throw new APIConnectionException(String.format("\u7487\u950b\u7730Icepay(%s)\u5bee\u509a\u7236,\u7487\u950b\ue5c5\u93cc\u30e7\u7d89\u7f01\u6ec4\u57a8\u95b2\u5d88\u762f.\u5bee\u509a\u7236\u6dc7\u2103\u4f05:%s", StringUtils.genUrl(url, options.getUri()), e.getMessage()), e);
        }
    }

    private static URL buildURL(APIResource.RequestMethod method, String spec, Map<String, Object> params) throws IOException {
        String queryString;
        StringBuilder sb = new StringBuilder();
        sb.append(spec);
        if (method != APIResource.RequestMethod.POST && method != APIResource.RequestMethod.PUT && params != null && !(queryString = APIIcepayRequest.createQuery(params)).isEmpty()) {
            sb.append("?");
            sb.append(queryString);
        }
        return new URL(sb.toString());
    }

    public static URL buildURLWithSign(String url, Map<String, Object> params, RequestOptions options) throws APIConnectionException {
        String queryString;
        String signature;
        params.put("version", options.getVersion());
        params.put("signType", options.getSignType());
        String requestTime = APIIcepayRequest.currentTimeString();
        params.put("reqTime", requestTime);
        params.put("appId", options.getAppId());
        try {
            signature = APIIcepayRequest.buildIcepaySignature(params, options);
        }
        catch (IOException e) {
            throw new APIConnectionException("\u9422\u71b8\u579aIcepay\u7487\u950b\u7730\u7edb\u60e7\u6095\u5bee\u509a\u7236", e);
        }
        if (signature != null) {
            params.put("sign", signature);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(StringUtils.genUrl(url, options.getUri()));
        if (params != null && !(queryString = APIIcepayRequest.createQuery(params)).isEmpty()) {
            sb.append("?");
            sb.append(queryString);
        }
        try {
            return new URL(sb.toString());
        }
        catch (IOException e) {
            throw new APIConnectionException("\u9422\u71b8\u579a Icepay \u7487\u950b\u7730URL\u5bee\u509a\u7236", e);
        }
    }

    private static HttpContent buildContent(APIResource.RequestMethod method, Map<String, Object> params, RequestOptions options) throws IcepayException {
        String signature;
        if (method != APIResource.RequestMethod.POST && method != APIResource.RequestMethod.PUT) {
            return null;
        }
        if (params == null) {
            return null;
        }
        params.put("appId", options.getAppId());
        params.put("version", options.getVersion());
        params.put("signType", options.getSignType());
        String requestTime = APIIcepayRequest.currentTimeString();
        params.put("reqTime", requestTime);
        try {
            signature = APIIcepayRequest.buildIcepaySignature(params, options);
        }
        catch (IOException e) {
            throw new APIConnectionException("\u9422\u71b8\u579aIcepay\u7487\u950b\u7730\u7edb\u60e7\u6095\u5bee\u509a\u7236", e);
        }
        if (signature != null) {
            params.put("sign", signature);
        }
        return HttpContent.buildJSONContent(params);
    }

    private static String createQuery(Map<String, Object> params) {
        if (params == null) {
            return "";
        }
        Map<String, String> flatParams = APIIcepayRequest.flattenParams(params);
        StringBuilder queryStringBuffer = new StringBuilder();
        for (Map.Entry<String, String> entry : flatParams.entrySet()) {
            if (queryStringBuffer.length() > 0) {
                queryStringBuffer.append("&");
            }
            queryStringBuffer.append(APIIcepayRequest.urlEncodePair(entry.getKey(), entry.getValue()));
        }
        return queryStringBuffer.toString();
    }

    private static String urlEncodePair(String k, String v) {
        return String.format("%s=%s", APIIcepayRequest.urlEncode(k), APIIcepayRequest.urlEncode(v));
    }

    protected static String urlEncode(String str) {
        if (str == null) {
            return null;
        }
        try {
            return URLEncoder.encode(str, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)"UTF-8 is unknown");
        }
    }

    private static Map<String, String> flattenParams(Map<String, Object> params) {
        if (params == null) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> flatParams = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Map) {
                HashMap<String, Object> flatNestedMap = new HashMap<String, Object>();
                Map nestedMap = (Map)value;
                for (Map.Entry nestedEntry : nestedMap.entrySet()) {
                    flatNestedMap.put(String.format("%s[%s]", key, nestedEntry.getKey()), nestedEntry.getValue());
                }
                flatParams.putAll(APIIcepayRequest.flattenParams(flatNestedMap));
                continue;
            }
            if (value instanceof ArrayList) {
                ArrayList ar = (ArrayList)value;
                HashMap<String, Object> flatNestedMap = new HashMap<String, Object>();
                int size = ar.size();
                for (int i = 0; i < size; ++i) {
                    flatNestedMap.put(String.format("%s[%d]", key, i), ar.get(i));
                }
                flatParams.putAll(APIIcepayRequest.flattenParams(flatNestedMap));
                continue;
            }
            if (value == null) {
                flatParams.put(key, "");
                continue;
            }
            flatParams.put(key, value.toString());
        }
        return flatParams;
    }

    private static HttpHeaders buildHeaders(APIResource.RequestMethod method, RequestOptions options) throws IcepayException {
        HashMap<String, List<String>> headerMap = new HashMap<String, List<String>>();
        headerMap.put("Accept", Collections.singletonList("application/json"));
        headerMap.put("Accept-Charset", Collections.singletonList(APIResource.CHARSET.name()));
        headerMap.put("Accept-Language", Collections.singletonList(options.getAcceptLanguage()));
        return HttpHeaders.of(headerMap);
    }

    protected static String buildIcepaySignature(Map<String, Object> params, RequestOptions options) throws IOException {
        String signType = options.getSignType();
        if ("MD5".equalsIgnoreCase(signType)) {
            return IcepayKit.getSign(params, options.getApiKey());
        }
        if ("RSA2".equalsIgnoreCase(signType)) {
            throw new AssertionError((Object)"\u93c6\u5099\u7b09\u93c0\ue21b\u5bd4RSA2\u7edb\u60e7\u6095");
        }
        throw new AssertionError((Object)"\u7487\u75af\ue195\u7f03\ue1bd\ue11c\u7ead\ue1be\u6b91\u7edb\u60e7\u6095\u7eeb\u8bf2\u7037");
    }

    protected static String currentTimeString() {
        int requestTime = (int)(System.currentTimeMillis() / 1000L);
        return Integer.toString(requestTime);
    }

    public APIResource.RequestMethod getMethod() {
        return this.method;
    }

    public URL getUrl() {
        return this.url;
    }

    public HttpContent getContent() {
        return this.content;
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public RequestOptions getOptions() {
        return this.options;
    }
}

