/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.pay;

import com.alibaba.fastjson.JSONObject;
import com.icetech.pay.exception.IcepayException;
import com.icetech.pay.net.APIIcepayRequest;
import com.icetech.pay.net.APIResource;
import com.icetech.pay.net.RequestOptions;
import com.icetech.pay.request.IcepayRequest;
import com.icetech.pay.response.IcepayResponse;
import com.icetech.pay.util.JSONWriter;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class IcepayClient
extends APIResource {
    private static final Map<String, IcepayClient> clientMap = new ConcurrentHashMap<String, IcepayClient>();
    private String appId;
    private String signType = "MD5";
    private String apiKey;
    private String apiBase;

    public IcepayClient(String apiBase, String appId, String apiKey) {
        this.apiBase = apiBase;
        this.appId = appId;
        this.apiKey = apiKey;
    }

    public static synchronized IcepayClient getInstance(String appId, String apiKey, String apiBase) {
        IcepayClient client = clientMap.get(appId);
        if (client != null) {
            client.appId = appId;
            client.apiKey = apiKey;
            client.apiBase = apiBase;
            return client;
        }
        client = new IcepayClient(apiBase, appId, apiKey);
        clientMap.put(appId, client);
        client.appId = appId;
        client.apiKey = apiKey;
        client.apiBase = apiBase;
        return client;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getSignType() {
        return this.signType;
    }

    public void setSignType(String signType) {
        this.signType = signType;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public String getApiBase() {
        return this.apiBase;
    }

    public void setApiBase(String apiBase) {
        this.apiBase = apiBase;
    }

    public <T extends IcepayResponse> T execute(IcepayRequest<T> request) throws IcepayException {
        if (request.getRequestOptions() == null) {
            RequestOptions options = RequestOptions.builder().setVersion(request.getApiVersion()).setUri(request.getApiUri()).setAppId(this.appId).setApiKey(this.apiKey).build();
            request.setRequestOptions(options);
        }
        return this.execute(request, APIResource.RequestMethod.POST, this.apiBase);
    }

    public String getRequestUrl(IcepayRequest request) throws IcepayException {
        if (request.getRequestOptions() == null) {
            RequestOptions options = RequestOptions.builder().setVersion(request.getApiVersion()).setUri(request.getApiUri()).setAppId(this.appId).setApiKey(this.apiKey).build();
            request.setRequestOptions(options);
        }
        String jsonParam = new JSONWriter().write(request.getBizModel(), true);
        JSONObject params = JSONObject.parseObject((String)jsonParam);
        request.getRequestOptions();
        return APIIcepayRequest.buildURLWithSign(this.apiBase, (Map<String, Object>)params, request.getRequestOptions()).toString();
    }
}

