package com.icetech.paycenter.domain.response.wechat;

import java.io.Serializable;

import com.icetech.paycenter.domain.response.AccessInfo;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

@Getter
@Setter
@ToString
@NoArgsConstructor
@AllArgsConstructor
@Accessors(chain = true)
public class WechatAccessToken implements Serializable {
    /** 网页授权接口调用凭证,注意：此access_token与基础支持的access_token不同 */
    protected String access_token;
    /** access_token接口调用凭证超时时间，单位（秒） */
    protected String expires_in;
    /** 用户刷新access_token */
    protected String refresh_token;
    /** 用户唯一标识，请注意，在未关注公众号时，用户访问公众号的网页，也会产生一个用户和公众号唯一的OpenID */
    protected String openid;
    /** 用户授权的作用域，使用逗号（,）分隔 */
    protected String scope;
    /** 是否为快照页模式虚拟账号，只有当用户是快照页模式虚拟账号时返回，值为1 */
    protected String is_snapshotuser;
    /** 用户统一标识（针对一个微信开放平台账号下的应用，同一用户的 unionid 是唯一的），只有当scope为"snsapi_userinfo"时返回 */
    protected String unionid;

    public AccessInfo toAccessInfo(){
        AccessInfo accessInfo = new AccessInfo();
        accessInfo.setAccess_token(this.access_token);
        accessInfo.setExpires_in(this.expires_in);
        accessInfo.setRefresh_token(this.refresh_token);
        accessInfo.setOpenid(this.openid);
        accessInfo.setScope(this.scope);
        accessInfo.setIs_snapshotuser(this.is_snapshotuser);
        accessInfo.setUnionid(this.unionid);
        return accessInfo;
    }
}
