package com.icetech.paycenter.domain.normalpay.request;

import com.icetech.common.annotation.NotNull;
import lombok.Data;

import java.io.Serializable;

/**
 * 发起退款请求
 *
 * @author wangzw
 */
@Data
public class RefundRequest implements Serializable {
    /**
     * 停车场编号
     */
    @NotNull
    private String parkCode;
    /**
     * 系统交易流水号
     */

    private String tradeNo;
    /**
     * 商户端交易流水号
     */

    private String outTradeNo;

    /**
     * 退款流水号(系统生成)
     */
    @NotNull
    private String refundTradeNo;
    /**
     * 价格
     */
    @NotNull
    private String price;
    /**
     * 退款说明
     */
    @NotNull
    private String orderNote;

    /**
     * 退款来源
     * MINIDEFAULT - 小程序支付
     * YUEDANDEFAULT   - H5支付
     */
    private String refundSource;

    /**
     * 流水单
     */
    private Object accountRecord;
}
