package com.icetech.paycenter.api;


import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.paycenter.domain.request.RedpackPreSendRequest;
import com.icetech.paycenter.domain.request.RedpackSendRequest;

/**
 * 红包零钱发放
 * @author fangct
 */
public interface IRedpackService {

    /**
     * 发放红包
     * @param redpackSendRequest
     * @return
     */
    ObjectResponse sendRedpack(RedpackSendRequest redpackSendRequest);
    /**
     * 查询红包
     * @param parkCode
     * @param tradeNo
     * @return
     */
    ObjectResponse queryRedpack(String parkCode, String tradeNo);

    /**
     * 批量更新状态
     * @return
     */
    ObjectResponse batchUpdateRedpackStaus();

    /**
     * 新版-预发送红包
     * @param redpackPreSendRequest
     * @return
     */
    ObjectResponse preSendRedpack(RedpackPreSendRequest redpackPreSendRequest);
    /**
     * 新版-发放红包
     * @param preId
     * @param appType 应用类型，微信/支付宝
     * @param unionId
     * @return
     */
    ObjectResponse sendRedpackV2(String preId, Integer appType, String unionId, String sendName);
}
