package com.icetech.paycenter.api;

import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.paycenter.domain.request.icepay.IceSubmitApplyParam;
import com.icetech.paycenter.domain.response.icepay.IceQueryApplyResult;
import com.icetech.paycenter.domain.response.icepay.IceSubmitApplyResult;

import java.util.Map;

/**
 * @author kate
 */
public interface IAutoConfigService {
    /**
     * 微信自动配置
     * @param subMchId
     * @param parkId
     * @return
     */
    ObjectResponse autoConfig4Wx(String subMchId, Integer parkId);

    /**
     * 云纵进件并自动配置
     * @param parkId
     * @param params
     * @return
     */
    ObjectResponse createPark4Yz(Integer parkId, Map<String,Object> params);

    /**
     * 获取进件链接
     * @param parkId
     * @return
     */
    ObjectResponse getLink4Yz(Integer parkId);

    /**
     * 查询车场的进件状态
     * @param parkId
     * @return
     */
    ObjectResponse<Map<String,String>> queryYzStatus(Integer parkId);

    ObjectResponse<IceSubmitApplyResult> applyIceMerchant(IceSubmitApplyParam param);

    ObjectResponse<IceQueryApplyResult> queryIceApplyResult(Integer parkId);
}
