/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.partner.domain.response.luogang;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import java.io.Serializable;

public class Response<T>
implements Serializable {
    protected Boolean flag;
    protected Integer code;
    protected String msg;
    protected T data;
    public static final TypeReference<Response<Void>> RESP_TYPE_VOID = new TypeReference<Response<Void>>(){};
    public static final TypeReference<Response<JSONObject>> RESP_TYPE_GET_TOKEN = new TypeReference<Response<JSONObject>>(){};
    public static final Integer CODE_SUCCESS = 1;
    public static final Integer CODE_FAILED = -1;

    public static boolean isSuccess(Response<?> response) {
        return response != null && (Boolean.TRUE.equals(response.getFlag()) || CODE_SUCCESS.equals(response.getCode()));
    }

    public static <T> Response<T> failed(String msg) {
        return Response.failed(CODE_FAILED, msg);
    }

    public static <T> Response<T> failed(int code, String msg) {
        return new Response<Object>(false, code, msg, null);
    }

    public static <T> Response<T> success() {
        return Response.success(null);
    }

    public static <T> Response<T> success(T data) {
        return new Response<T>(true, CODE_SUCCESS, null, data);
    }

    public static <T> Response<T> getInstance(int code, String msg) {
        return new Response<Object>(CODE_SUCCESS == code, code, msg, null);
    }

    public Boolean getFlag() {
        return this.flag;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    public T getData() {
        return this.data;
    }

    public Response<T> setFlag(Boolean flag) {
        this.flag = flag;
        return this;
    }

    public Response<T> setCode(Integer code) {
        this.code = code;
        return this;
    }

    public Response<T> setMsg(String msg) {
        this.msg = msg;
        return this;
    }

    public Response<T> setData(T data) {
        this.data = data;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Response)) {
            return false;
        }
        Response other = (Response)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$flag = this.getFlag();
        Boolean other$flag = other.getFlag();
        if (this$flag == null ? other$flag != null : !((Object)this$flag).equals(other$flag)) {
            return false;
        }
        Integer this$code = this.getCode();
        Integer other$code = other.getCode();
        if (this$code == null ? other$code != null : !((Object)this$code).equals(other$code)) {
            return false;
        }
        String this$msg = this.getMsg();
        String other$msg = other.getMsg();
        if (this$msg == null ? other$msg != null : !this$msg.equals(other$msg)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Response;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $flag = this.getFlag();
        result = result * 59 + ($flag == null ? 43 : ((Object)$flag).hashCode());
        Integer $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : ((Object)$code).hashCode());
        String $msg = this.getMsg();
        result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    public String toString() {
        return "Response(flag=" + this.getFlag() + ", code=" + this.getCode() + ", msg=" + this.getMsg() + ", data=" + this.getData() + ")";
    }

    public Response() {
    }

    public Response(Boolean flag, Integer code, String msg, T data) {
        this.flag = flag;
        this.code = code;
        this.msg = msg;
        this.data = data;
    }
}

