package com.icetech.partner.domain.response;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;

@Setter
@Getter
@ToString
public class QueryExitRecordResponse implements Serializable {
    @ApiModelProperty(value = "停车场编号", required = true, example = "P100000", position = 1)
    private String parkCode;
    
    @ApiModelProperty(value = "停车场名称", required = true, example = "北辰停车场", position = 2)
    private String parkName;
    
    @ApiModelProperty(value = "订单号，确保订单号在此车场内的唯一性", required = true, example = "1000000220020", position = 3)
    private String orderNum;

    @ApiModelProperty(value = "车牌号", required = true, example = "京A88888", position = 4)
    private String plateNum;

    @ApiModelProperty(value = "入口名称", required = true, example = "北入口", position = 5)
    private String channelName;

    @ApiModelProperty(value = "出场时间（unix时间戳 10位）", required = true, example = "北入口", position = 6)
    private Long exitTime;

    @ApiModelProperty(value = "停车时长（秒）", required = true, example = "100", position = 7)
    private Long parkTime;

    @ApiModelProperty(value = "车辆类型，详情查看数据定义部分", required = true, example = "2", position = 8)
    private Integer type;

    @ApiModelProperty(value = "车型，详情查看数据定义部分", required = true, example = "2", position = 9)
    private Integer carType;

    @ApiModelProperty(value = "总金额，从入场到出场产生的应收总费用", required = true, example = "10.00", position = 10)
    private Double totalAmount;

    @ApiModelProperty(value = "实收总金额，从入场到出场产生的实收总费用", required = true, example = "10.00", position = 11)
    private Double paidAmount;

    @ApiModelProperty(value = "优惠总金额，从入场到出场产生的优惠总费用", required = true, example = "0.00", position = 12)
    private Double discountAmount;

    @ApiModelProperty(value = "离场图片URL，注意：url有效期为30分钟", example = "", position = 13)
    private String imgUrl;

    @ApiModelProperty(value = "车牌颜色", example = "蓝色", position = 14)
    private String plateColor;

    @ApiModelProperty(value = "是否异常离场", example = "1", position = 15)
    private Integer isExceptionExit;
}
