package com.icetech.partner.domain.response;

import com.alibaba.fastjson.JSON;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * Description BstAdBidResponse
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @Date 2023/6/14 14:39
 */
@Data
public class BstAdBidResponse implements Serializable {

    /**
     * 请求Id 同请求中的requestId一致
     */
    private String requestId;

    /**
     * 中标的广告席位。参考对象说明文档
     */
    private BstAdSeatResponse bidSeat;

    /**
     * 打底广告席位。参考对象说明文档
     */
    private BstAdSeatResponse defaultSeat;

    @Data
    public static class BstAdSeatResponse implements Serializable {

        /**
         * 广告竞投Id（系统生成
         */
        private String bidId;

        /**
         * 中标席位Id（推广计划UUID）
         */
        private String seatId;

        /**
         * 出价，中标曝光价格，单位元
         */
        private BigDecimal price;

        /**
         * (用户点击）跳转目标的类型:0:Url,超链接;1：Applet,小程序跳小程序; 2:None,无点击处理，忽略target内容; 3 小程序跳转H5页面
         */
        private Integer targeType;

        /**
         * 跳转目标. targeType=0或 targeType=3时， target 为html超连接； targeType=1时，target的内容为则小程序地址。 小程序地址包含两部分内容：appId 和path，中间由逗号分隔，appId 是必须的，path则在默认页的情况下可以为空。就是没有逗号分隔的情况下，里面内容为小程序的appid;有逗号分隔，则逗号前为appid，逗号后为path
         */
        private String target;

        /**
         * 播放素材数组。参考 4.2 广告播放素材。数组长度通常为1，简化处理的话，直接加载数组的第一个素材即可
         */
        private List<BstMaterias> materias;

        @Data
        private static class BstMaterias implements Serializable {

            /**
             * 素材Id
             */
            private String id;

            /**
             * 素材类型。如jpg、gif、mp4、3gp 等文件扩展名，文字内容为text
             */
            private String type;

            /**
             * 素材地址。注意：不要在后台访问该地址，要在前端调用才行；后端访问的话这边获取到的特征是服务器的
             */
            private String url;

            /**
             * 素材宽度
             */
            private Integer width;

            /**
             * 素材高度
             */
            private Integer height;

            /**
             * 素材大小(KB)
             */
            private Integer size;

            /**
             * 播放时长(秒) ,主要针对视频类素材，其他类忽略该信息即可
             */
            private Integer playTime;
        }
    }

}
