package com.icetech.partner.domain.response;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class AdviceResponse implements Serializable {
    /**
     * 车场编号
     */
    private String parkCode;
    /**
     * 图片链接
     */
    private String creativeUrl;
    /**
     * 图片高度
     */
    private String height;
    /**
     * 图片 宽度
     */
    private String width;
    /**
     * 着陆页地址，用户点击banner图片后需要跳转的广告详情地址
     */
    private String landingPage;

    /**
     * 广告渠道: 1:安泊; 2:云纵;
     */
    private Integer advertChannel;

    /**
     * 三方车场id
     */
    private String thirdParkId;

    /**
     * 安泊聚合appId
     */
    private String appId;

    /**
     * 是否自动打开广告，1: 是
     */
    private Integer isAutoOpen;

    /**
     * 自动打开广告的 是否自动点击，1: 是
     */
    private Integer isAutoOpenClick;
    /**
     * 完成后跳转地址
     */
    private String jumpUrl;
    /**
     * 弹框广告图片链接
     */
    private String popImageUrl;
    /**
     * 弹框广告跳转地址
     */
    private String popLinkUrl;
}
