package com.icetech.partner.domain.request.yongcheng;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @author wanggang
 * @create 2025-03-17 14:47
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class YongChengAutoPayRequest implements Serializable {

    /**
     * 停车场 ID
     */
    private String parkpotId;

    /**
     * 停车场停车场业务 id，同一次进出完成，将拥有
     * 同一个停车业务 id
     * 同一个停车场下，该 ID 不能重复
     */
    private String extBusinessId;

    /**
     * 应交费总金额（停车费总金额）（单位：分）
     * 如果是共享停车的可传 0，系统会自行计算停车
     * 费
     */
    private Integer paymentTotal;

    /**
     * 本次交易金额（单位：分）
     * 如果是共享停车的可传 0
     */
    private Integer totalFee;

    /**
     * 停车场支付订单号
     */
    private String outTradeNo;

    /**
     * 账单生成时间，格式：yyyy-MM-dd HH:mm:ss
     */
    private String outTradeTime;

    /**
     * 0：默认先扣优惠再扣余额，1 只扣优惠不扣余额
     * 余额不足的优惠不使用（暂时只支持传 0）
     */
    private String autoPayType;

    /**
     * 停车场道闸编号
     */
    private String gateno;
}
