package com.icetech.partner.domain.request.shanghai;

import lombok.Data;

import java.io.Serializable;

@Data
public class ShEnterRequest implements Serializable {
    /**
     *交易序列号，需唯一，最大长度32 位
     * 必填
     */
    private String seq;
    /**
     *车牌号
     * 必填
     */
    private String plateId;
    /**
     *车型
     * 1-大型
     * 2-中型
     * 3-小型
     * 9-其它
     * 必填
     */
    private Integer vehicleType;
    /**
     *1-人工
     * 2-自动（ETC、无感等） 9-其它
     * 必填
     */
    private Integer laneType = 9;
    /**
     *空余车位数
     * 必填
     */
    private Integer freeBerth;
    /**
     *停车类型
     * 1-临停
     * 2-包月
     * 9-其它
     */
    private Integer parkType;
    /**
     *入场时间： UTC时间戳，从1970年1 月1日0点0分0秒开始到现在的毫秒数,例如：1420123421000
     */
    private Long dataTime;
    /**
     *签名结果
     */
    private String sign;

}
