package com.icetech.partner.domain.request.open;

import com.icetech.common.annotation.NotNull;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;

/**
 * 2.8.续费月卡
 */
@Setter
@Getter
@ToString
public class RenewMonthCardRequest implements Serializable {
    /**
     * 车场编号
     */
    @NotNull
    String parkCode;
    /**
     * 月卡产品id
     */
    @NotNull
    long productId;
    /**
     * 月卡id
     */
    @NotNull
    long cardId;
    /**
     * 用户/公司名称
     */
    @NotNull
    String cardOwner;
    /**
     * 车牌号
     */
    @NotNull
    String plateNum;
    /**
     * 手机号
     */
    @NotNull
    String phone;
    /**
     * 车位数量，默认为1，可支持多车位多车
     */
    @NotNull
    int plotCount;
    /**
     * 车位号
     */
    String plotNum;
    /**
     * 月卡有效开始日期，格式为年-月-日
     */
    @NotNull
    String startTime;
    /**
     * 月卡有效结束日期，格式为年-月-日
     */
    @NotNull
    String endTime;
}
