package com.icetech.partner.domain.request.open;

import com.icetech.common.annotation.NotNull;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * @author zhangpengzhan
 * @date 2021/1/14 17:07
 */
@Data
public class QueryMonthProductRequest implements Serializable {
    @NotNull
    @NotBlank(message = "停车场编码不能为空")
    @ApiModelProperty(value = "云平台停车场编码", required = true, example = "1P1594692385", position = 1)
    private String parkCode;
    /**
     * 月卡产品Id
     */
    @ApiModelProperty(value = "月卡产品Id, 默认查询车场全部月卡套餐信息",example = "1", position = 2)
    private String productId;
}
